#include "stdafx.h"
#include "DataElement.h"
#include "SDP.h"




DataElement::DataElement(BYTE type, BYTE* payLoad, USHORT length /*payLoad should already be Big-Endian, no conversions done here*/)
    {
        
        
        USHORT i,tmpUS;
        UWORD tmpUW;
        const char* IcmTL = "Incompatability between Data Element Type and Payload Length or unsupported type's size";
        const char* InvT = "Invalid Type";
        const char* UnImpltd = "Type not implemented yet";
        this->allocatedDE = 1;
        switch(type)             
            {
                case SDP_DataElementType_Nil:
                    
                    this->theDataElement = (SDP_DataElementHeaderStruct) new BYTE[wholeSize = 0+SDP_DataElementHeaderLength];                    
                    this->theDataElement->sizeIndex = 0;
                    break;
                    

                case SDP_DataElementType_UInt:
                    switch(length)
                        {
                            case 1: //BYTE
                                this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 1+SDP_DataElementHeaderLength];                    
                                this->theDataElement->sizeIndex = 0;
                                ((BYTE*)(this->theDataElement))[1] = payLoad[0];
                                break;

                            case 2: //BEUSH
                                this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 2+SDP_DataElementHeaderLength];                    
                                this->theDataElement->sizeIndex = 1;
                                ((BYTE*)(this->theDataElement))[1] = payLoad[0];
                                ((BYTE*)(this->theDataElement))[2] = payLoad[1];
                                break;
                            
                            case 4: //BEUSW
                                this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 4+SDP_DataElementHeaderLength];                    
                                this->theDataElement->sizeIndex = 2;
                                ((BYTE*)(this->theDataElement))[1] = payLoad[0];
                                ((BYTE*)(this->theDataElement))[2] = payLoad[1];
                                ((BYTE*)(this->theDataElement))[3] = payLoad[2];
                                ((BYTE*)(this->theDataElement))[4] = payLoad[3];
                                break;

                            default: throw IcmTL;
                        }
                    break;

                case SDP_DataElementType_STwosComplementInt:
                    throw UnImpltd;                    
                    break;

                case SDP_DataElementType_UUID:
                    switch(length)
                        {
                            case 1: //BYTE
                                this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 1+SDP_DataElementHeaderLength];                    
                                this->theDataElement->sizeIndex = 0;
                                ((BYTE*)(this->theDataElement))[1] = payLoad[0];
                                break;

                            case 2: //BEUSH
                                this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 2+SDP_DataElementHeaderLength];                    
                                this->theDataElement->sizeIndex = 1;
                                ((BYTE*)(this->theDataElement))[1] = payLoad[0];
                                ((BYTE*)(this->theDataElement))[2] = payLoad[1];
                                break;
                            
                            case 4: //BEUSW
                                this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 4+SDP_DataElementHeaderLength];                    
                                this->theDataElement->sizeIndex = 2;
                                ((BYTE*)(this->theDataElement))[1] = payLoad[0];
                                ((BYTE*)(this->theDataElement))[2] = payLoad[1];
                                ((BYTE*)(this->theDataElement))[3] = payLoad[2];
                                ((BYTE*)(this->theDataElement))[4] = payLoad[3];
                                break;

                            default: throw IcmTL;
                        }
                    
                    break;


                case SDP_DataElementType_TextString:
                    
                    if(length < 256)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 1/*the 8 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 5;                                             
                            ((BYTE*) this->theDataElement)[1] = length;
                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+2] = payLoad[i]; // 2: 1 for the header, 1 for the special length byte


                        }
                    else if(length < 65536)
                        {
                             this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 2/*the 16 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 6;                                             
                            
                            tmpUS = length;
                            Converter::swapUSHORT(&tmpUS);
                            *((USHORT*)(((BYTE*) this->theDataElement)+1)) = tmpUS;

                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+3] = payLoad[i]; // 3: 1 for the header, 2 for the special length byte
                        }
                    else if(length < 4294967296)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 4/*the 32 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 7;                                             
                            
                            tmpUW = length;
                            Converter::swapUWORD(&tmpUW);
                            *((UWORD*)(((BYTE*) this->theDataElement)+1)) = tmpUW;


                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+5] = payLoad[i]; // 5: 1 for the header, 4 for the special length byte
                        }
                    else
                        throw IcmTL;



                    break;

                case SDP_DataElementType_Boolean:
                    throw UnImpltd;                    
                    break;

                case SDP_DataElementType_DataElementSequence:
                     
                    if(length < 256)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 1/*the 8 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 5;                                             
                            ((BYTE*) this->theDataElement)[1] = length;
                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+2] = payLoad[i]; // 2: 1 for the header, 1 for the special length byte


                        }
                    else if(length < 65536)
                        {
                             this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 2/*the 16 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 6;                                             
                            
                            tmpUS = length;
                            Converter::swapUSHORT(&tmpUS);
                            *((USHORT*)(((BYTE*) this->theDataElement)+1)) = tmpUS;

                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+3] = payLoad[i]; // 3: 1 for the header, 2 for the special length byte
                        }
                    else if(length < 4294967296)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 4/*the 32 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 7;                                             
                            
                            tmpUW = length;
                            Converter::swapUWORD(&tmpUW);
                            *((UWORD*)(((BYTE*) this->theDataElement)+1)) = tmpUW;


                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+5] = payLoad[i]; // 5: 1 for the header, 4 for the special length byte
                        }
                    else
                        throw IcmTL;



                    break;

                
                
                case SDP_DataElementType_DataElementAlternative:
                     if(length < 256)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 1/*the 8 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 5;                                             
                            ((BYTE*) this->theDataElement)[1] = length;
                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+2] = payLoad[i]; // 2: 1 for the header, 1 for the special length byte


                        }
                    else if(length < 65536)
                        {
                             this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 2/*the 16 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 6;                                             
                            
                            tmpUS = length;
                            Converter::swapUSHORT(&tmpUS);
                            *((USHORT*)(((BYTE*) this->theDataElement)+1)) = tmpUS;

                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+3] = payLoad[i]; // 3: 1 for the header, 2 for the special length byte
                        }
                    else if(length < 4294967296)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 4/*the 32 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 7;                                             
                            
                            tmpUW = length;
                            Converter::swapUWORD(&tmpUW);
                            *((UWORD*)(((BYTE*) this->theDataElement)+1)) = tmpUW;


                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+5] = payLoad[i]; // 5: 1 for the header, 4 for the special length byte
                        }
                    else
                        throw IcmTL;



                    break;

                case SDP_DataElementType_URL:
                     if(length < 256)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 1/*the 8 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 5;                                             
                            ((BYTE*) this->theDataElement)[1] = length;
                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+2] = payLoad[i]; // 2: 1 for the header, 1 for the special length byte


                        }
                    else if(length < 65536)
                        {
                             this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 2/*the 16 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 6;                                             
                            
                            tmpUS = length;
                            Converter::swapUSHORT(&tmpUS);
                            *((USHORT*)(((BYTE*) this->theDataElement)+1)) = tmpUS;

                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+3] = payLoad[i]; // 3: 1 for the header, 2 for the special length byte
                        }
                    else if(length < 4294967296)
                        {
                            this->theDataElement = (SDP_DataElementHeaderStruct)new BYTE[wholeSize = 4/*the 32 bits extra which holds the size*/+length+SDP_DataElementHeaderLength];                    
                            this->theDataElement->sizeIndex = 7;                                             
                            
                            tmpUW = length;
                            Converter::swapUWORD(&tmpUW);
                            *((UWORD*)(((BYTE*) this->theDataElement)+1)) = tmpUW;


                            for(i=0;i<length;i++)
                                ((BYTE*)(this->theDataElement))[i+5] = payLoad[i]; // 5: 1 for the header, 4 for the special length byte
                        }
                    else
                        throw IcmTL;



                    break;


                default: throw InvT;
            }

        
        
            this->theDataElement->type = type;
        //    this->dataInitialized =1;
        
        
      
    };
BYTE* DataElement::ExtractDataElement(SDP_DataElementHeaderStruct theDataElement/*this is a pointer!!!*/,UWORD* retSize)
        {
        
        // this function will just point to the start of the object and tell the length in BYTEs, 
        //the length is converted to windows Little endian form. But the Data is as original (Big-Endain!) so remember to convert any USHORTs or types that are bigger than 1 byte and need re-ordering
        USHORT tmpUSH;
        UWORD  tmpUWD;
//        USHORT* USHp;
  //      UWORD* UWDp;
        // if retSize is larger than the real size of that type then it means that there's an array of objects at the return address, and the size of all of the objects combined are (retSize) Bytes.
        switch(theDataElement->type)
            {
                case SDP_DataElementType_Nil:
                    switch(theDataElement->sizeIndex)
                        {
                            case    0:  *retSize =  0;  return (BYTE*)theDataElement;  break;
                            
                            default: return NULL;
                        }
                    break;
                case SDP_DataElementType_UInt:
                    switch(theDataElement->sizeIndex)
                        {
                            case 0: *retSize = 1;    return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            case 1: *retSize = 2;    return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            case 2: *retSize = 4;    return ((BYTE*)theDataElement)+1/*next byte*/; break; 
                            case 3: *retSize = 8;    return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            case 4: *retSize = 16;   return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            
                            default: return NULL;
                        }
                    break;
                case SDP_DataElementType_STwosComplementInt:
                    switch(theDataElement->sizeIndex)
                        {
                            case 0: *retSize = 1;    return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            case 1: *retSize = 2;    return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            case 2: *retSize = 4;    return ((BYTE*)theDataElement)+1/*next byte*/; break; 
                            case 3: *retSize = 8;    return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            case 4: *retSize = 16;   return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            
                            default: return NULL;
                        }
                    break;
                case SDP_DataElementType_UUID:
                    switch(theDataElement->sizeIndex)
                        {
                        case 1: *retSize = 2; return(((BYTE*)theDataElement)+1);break;//NOT CONVERTED!!!
                        case 2: *retSize = 4; return(((BYTE*)theDataElement)+1);break;//NOT CONVERTED!!! 
                            
                            //implement this later    //case 4: *retSize = 16;   return ((BYTE*)de)+1/*next byte*/; break;
                            
                            default: return NULL;
                    break;
                        }
                case SDP_DataElementType_TextString:
                    switch(theDataElement->sizeIndex)
                        {
                            case 5: *retSize = *(((BYTE*)theDataElement)+1);    return ((BYTE*)theDataElement)+2/*1+1 skip the 1 byte size-telling byte*/; break;
                            case 6: tmpUSH = *(USHORT*)(((BYTE*)theDataElement)+1); Converter::swapUSHORT(&tmpUSH); *retSize = tmpUSH;    return ((BYTE*)theDataElement)+3/*1+2 skip 16 bits*/; break;
                            case 7: tmpUWD = *(UWORD*)(((BYTE*)theDataElement)+1); Converter::swapUWORD(&tmpUWD);*retSize = tmpUWD;    return ((BYTE*)theDataElement)+5/*1+4 skip 32 bits*/; break; 
                            
                            default: return NULL;
                        }
                    break;
                case SDP_DataElementType_Boolean:
                    switch(theDataElement->sizeIndex)
                        {
                            case 0: *retSize = 1;    return ((BYTE*)theDataElement)+1/*next byte*/; break;
                            
                            default: return NULL;
                        }
                    
                    break;
                case SDP_DataElementType_DataElementSequence:
                    switch(theDataElement->sizeIndex)
                        {
                            
                            case 5: printf("herer");*retSize = *(((BYTE*)theDataElement)+1);    return ((BYTE*)theDataElement)+2/*1+1 skip the 1 byte size-telling byte*/; break;
                            case 6: tmpUSH = *(USHORT*)(((BYTE*)theDataElement)+1); Converter::swapUSHORT(&tmpUSH); *retSize = tmpUSH;    return ((BYTE*)theDataElement)+3/*1+2 skip 16 bits*/; break;
                            case 7: tmpUWD = *(UWORD*) (((BYTE*)theDataElement)+1); Converter::swapUWORD(&tmpUWD);*retSize = tmpUWD;    return ((BYTE*)theDataElement)+5/*1+4 skip 32 bits*/; break; 
                            
                            default: return NULL;
                        }
                    break;
                case SDP_DataElementType_DataElementAlternative:
                    switch(theDataElement->sizeIndex)
                        {
                            case 5: printf("herer");*retSize = *(((BYTE*)theDataElement)+1);    return ((BYTE*)theDataElement)+2/*1+1 skip the 1 byte size-telling byte*/; break;
                            case 6: tmpUSH = *(USHORT*)(((BYTE*)theDataElement)+1); Converter::swapUSHORT(&tmpUSH); *retSize = tmpUSH;    return ((BYTE*)theDataElement)+3/*1+2 skip 16 bits*/; break;
                            case 7: tmpUWD = *(UWORD*) (((BYTE*)theDataElement)+1); Converter::swapUWORD(&tmpUWD);*retSize = tmpUWD;    return ((BYTE*)theDataElement)+5/*1+4 skip 32 bits*/; break; 
                            
                            default: return NULL;
                        }
                    break;
                case SDP_DataElementType_URL:
                    switch(theDataElement->sizeIndex)
                        {
                            case 5: printf("herer");*retSize = *(((BYTE*)theDataElement)+1);    return ((BYTE*)theDataElement)+2/*1+1 skip the 1 byte size-telling byte*/; break;
                            case 6: tmpUSH = *(USHORT*)(((BYTE*)theDataElement)+1); Converter::swapUSHORT(&tmpUSH); *retSize = tmpUSH;    return ((BYTE*)theDataElement)+3/*1+2 skip 16 bits*/; break;
                            case 7: tmpUWD = *(UWORD*) (((BYTE*)theDataElement)+1); Converter::swapUWORD(&tmpUWD);*retSize = tmpUWD;    return ((BYTE*)theDataElement)+5/*1+4 skip 32 bits*/; break; 
                            
                            default: return NULL;
                        }
                    break;
                default: return NULL;
            }
    };
DataElement::DataElement(BYTE* element, USHORT length)
{
    
    this->allocatedDE = 0;
    this->theDataElement = (SDP_DataElementHeaderStruct) element;
    this->wholeSize = length;


        
}


/*
DataElement::DataElement(BYTE type, int size)
    {
    
        this->dataInitialized =0;
    };
*/

BYTE * DataElement::ExtractDataElement(UWORD* retSize)
    {
        return ExtractDataElement((SDP_DataElementHeaderStruct) this->theDataElement,retSize);
    };





UUID_ValParam* DataElement::ExtractDataElementForUUID(SDP_DataElementHeaderStruct de, USHORT* nParams)//extract and show dataelement sequences
{
	unsigned int rets,elength,depth=0,i,j;
	
	BYTE* bp = (BYTE*) de;
	BYTE* pbp;
	BYTE paramFlag=0;
	UUID_ValParam* ret; 
	
	pbp=bp;
	bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)pbp,&rets);
	elength = rets;
//	printf("\nType: %d Size: %d Value: ",((SDP_DataElementHeaderStruct)pbp)->type,rets);
//	for(i=0;i<rets;i++)
//			printf("%02x ",bp[i]);





//	elength = rets;
	printf("\nelength %d\n",elength);

	printf("\ndiff %d\n\n\n",bp-(BYTE*)de);
	
	de = (SDP_DataElementHeaderStruct)bp;
	/*pbp=bp;
	bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)pbp,&rets);

	printf("\nType: %d Size: %d Value: ",((SDP_DataElementHeaderStruct)pbp)->type,rets);
	for(i=0;i<rets;i++)
			printf("%02x ",bp[i]);
	
	printf("\ndiff %d\n",bp-(BYTE*)de);*/
	
//for(i=0;i<11;i++)
	*nParams = 0;

	while(true)
	{

		
	//	printf("\n\n\%d\n\n",i);
		

		if(bp==NULL || bp >= elength+(BYTE*)de)
			break;
		printf("\n\n\t\tdiff: %d, res: %d  : elength %d\n",bp-(BYTE*)de,rets,elength);


		
		

		
		
		
		printf("\nType: %d Size: %d Value: ",((SDP_DataElementHeaderStruct)pbp)->type,rets);
		for(j=0;j<rets;j++)
			printf("%02x ",bp[j]);

		if( ((SDP_DataElementHeaderStruct)pbp)->type == 3)//UUID
		{(*nParams)++;}		
		if( ((SDP_DataElementHeaderStruct)pbp)->type != 6)//DataElementSequence
		{bp+= rets; printf("Skipped additional %d bytes to next element",rets);}
		


		pbp=bp;	
		bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)pbp,&rets);
		




	}
	

	ret = new UUID_ValParam[*nParams];

	for(i=0;i<*nParams;i++)
	{ret[i].UUID[0]=0;ret[i].UUID[1]=0;ret[i].val=NULL;ret[i].valLength=0;}

	printf("\n\n\n%d\n\n\n", *nParams);


	bp = (BYTE*) de;

	

	i=0;
	
	while(true)
	{

		
	//	printf("\n\n\%d\n\n",i);
		

		if(bp==NULL || bp >= elength+(BYTE*)de)
			break;
		printf("\n\n\t\tdiff: %d, res: %d  : elength %d\n",bp-(BYTE*)de,rets,elength);


		
		

		
		
		
		printf("\nType: %d Size: %d Value: ",((SDP_DataElementHeaderStruct)pbp)->type,rets);
		for(j=0;j<rets;j++)
			printf("%02x ",bp[j]);

		if(paramFlag == 1 && ((SDP_DataElementHeaderStruct)pbp)->type != 6)
			{ret[i-1].val = bp;ret[i-1].valLength = rets;printf("\nRETVALLLLLLLLLLLLLLLLLLLLLLLLLLLL %02x%02x\n",bp[0],bp[1]);}

		if( ((SDP_DataElementHeaderStruct)pbp)->type == 3)
			{ret[i++].UUID[0] = bp[0];ret[i-1].UUID[1] = bp[1];paramFlag = 1;printf("FVAL: %02x%02x",bp[0],bp[1]);}			
		
		if( ((SDP_DataElementHeaderStruct)pbp)->type != 6)
			{bp+= rets; printf("Skipped additional %d bytes to next element",rets);}		
		else 
			{paramFlag = 0;}


		pbp=bp;	
		bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)pbp,&rets);
		




	}
	
	return ret;
	
	/*


	rem = rets;

	while(rem>0)
	{
		printf("\nsize %d",rets);
		
	}


		
		, val: %x, type: %d ",rets,*bp,((SDP_DataElementHeaderStruct)bp)->type);
	bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)bp,&rets);	
	printf("\n\tsize %d, val: %x, type: %d ",rets,*bp,((SDP_DataElementHeaderStruct)bp)->type);
	bp+=rets;
	//printf("\n\tsize %d, val: %x, type: %d ",rets,*bp,((SDP_DataElementHeaderStruct)bp)->type);
	bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)bp,&rets);
	printf("\n\t\tsize %d, val: %x, type: %d ",rets,*bp,((SDP_DataElementHeaderStruct)bp)->type);
	bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)bp,&rets);
	printf("\n\t\t\tsize %d, val: %x, type: %d ",rets,*bp,((SDP_DataElementHeaderStruct)bp)->type);
	bp = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct)bp,&rets);
	printf("\n\t\t\t\tsize %d, val: %x, type: %d ",rets,*bp,((SDP_DataElementHeaderStruct)bp)->type);
*/
}

BYTE DataElement::ExtractForRFCOMMChannel(SDP_DataElementHeaderStruct de)// n vals
{
	USHORT nParams;
	UUID_ValParam* res = DataElement::ExtractDataElementForUUID(de,&nParams);

	BYTE ret=0;
	BEUS obopUUID(UUID_RFCOMM);

	int i,j;
	for(i=0; i< nParams;i++)
	{
		printf("\n\n\nUUID: %02x%02x\n Params: ",res[i].UUID[0], res[i].UUID[1]);
		if(obopUUID.equals(res[i].UUID) && res[i].valLength)
			ret = res[i].val[0] ;

		for(j=0;j<res[i].valLength;j++)
			printf("%02x",res[i].val[j]);
	
	}

	delete[] res;
	return ret;

};





/*

DataElementSequence::DataElementSequence()
    {
    
    };
        
DataElementSequence::append(DataElement* de)
    {
    
    };*/
