#include "stdafx.h"
#include ".\filesender.h"

FileSender::FileSender( FileSenderCaller* caller, CListBox* logLB, CListBox* devicesLB):HCIClient((HCIClientCaller*)caller,logLB)
	{
		
	this->logLB = logLB;
	this->devicesLB = devicesLB;
	this->ourMTU = L2CAP_DefaultMTU;
	this->caller = caller;
	this->sendingFile = false;

	}

void FileSender::UpdateDevicesLB()
{
	

	for(int i=0;i<InquiredDevices->GetSize();i++)
		if(((PBTDevice)InquiredDevices->GetAt(i))->Name[0] != NULL/*name not retrieved*/)
			this->devicesLB->AddString((char*)(((PBTDevice)InquiredDevices->GetAt(i))->Name));
		else
			{
				CString str;
				this->AddressToString(((PBTDevice)InquiredDevices->GetAt(i))->BD_ADDR,str);
				this->devicesLB->AddString(str);
			}

}
bool FileSender::GetNames(int i)
{
	PBTDevice	pBTDevice=NULL;
	//int			nDevice=0;

	
		devicesLB->SetCurSel(i);
		pBTDevice=NULL;
		pBTDevice=(PBTDevice)InquiredDevices->GetAt(i);
		if (pBTDevice)
		{
			
			
			if (FBT_HCI_SUCCESS(((HCIServer*)Server)->RemoteNameRequest(
									pBTDevice->BD_ADDR,
									pBTDevice->PageScanRepetitionMode,
									pBTDevice->PageScanMode,
									pBTDevice->ClockOffset,
									pBTDevice->Name)))
			{
				devicesLB->DeleteString(i);
				devicesLB->InsertString(i, (LPCSTR)pBTDevice->Name);				

			}

			else
			{
				 caller->OnGetNamesComplete();
				return false;

			}

			 caller->OnGetNamesComplete();
				return true;
			

		}

	//docallback()
	  caller->OnGetNamesComplete();
	return false;
	
	
}



bool FileSender::DoInquiry()
	{
		devicesLB->ResetContent();
		return HCIClient::DoInquiry(); //call the normal super class's function
	}
		
void FileSender::HandleInquiryComplete()
	{
		this->UpdateDevicesLB();
		caller->OnInquiryComplete();		
		
		//docallback()
	}
bool FileSender::sendFileToDevice(CStdioFile *file, BTDevice device)// add call-back
	{
	//	if(sending)
	//		return false;
	if(file == NULL)
		return false;
	if(this->sendingFile)
		return false;
	this->sendingFile =true;
	this->file = file;
	ConnectionLevel=0;

/*USHORT ourCID;
USHORT theirCID;
USHORT ourMTU;
USHORT ourFlushTimeout;
USHORT theirMTU;
USHORT theirFlushTimeout;
  */
theirConfigureLevel=0;
ourConfigureLevel=0;
ourCommandIdentifier=1;
theirCommandIdentifier=1;

readComplete = 1;
bufferPos = 0;
expectedPacketLength = 0;
//BYTE OBEXOPChannel;

ourMSCResponded = 0;
theirMSCResponded = 0;
SDP_TransactionID = 0x0000;

		if(!(this->Connect(device)))
			return false;
		ourCID = 0x0040;
		L2CAP_ConnectionRequestCommandPacket lc(ourCommandIdentifier++,L2CAP_PSM_SDP,ourCID);	
		ConnectionLevel++;
		curL2CAPConnection = StartNewL2CAPForSDP;
		SendL2CAPPacket(&lc);
		logLB->AddString("l2 conn sent!");
        //PBTDevice pBTDevice=(PBTDevice) m_lbDevices.GetItemData(nDevice);	
	    //SendHCIDataPacket(pBTDevice, &lc);
		//Handle input will handle the rest
		return true;
	}
void FileSender::HandleInput(USHORT Handle,BYTE* payLoad,USHORT payLoadLength)
{
	ByteArray *ba=NULL;
	ba = new ByteArray(payLoad,payLoadLength);
try{	
	
	
	char buff[100];
	for(int i=0;i< ba->length ;i++)
		sprintf(buff,"%02x ",ba->array[i]);
	CString recvd("ba = ");
	recvd.Append(buff);
	logLB->AddString(recvd);
	

	//L2CAP_Packet pktIn(ba);
	

	if(curL2CAPConnection == StartNewL2CAPForSDP)		
	{//FIRST L2CAP_Connection (For SDP)
	switch (ConnectionLevel)
	{
		
		
		case L2CAP_Level_WaitingForConResp:
			//MessageBox("vfygn  1");
			try
			{
				//MessageBox("goig to intl obj");
			
				L2CAP_ConnectionResponseCommandPacket* rp = new L2CAP_ConnectionResponseCommandPacket(ba);
                //MessageBox("made");
				if( rp->theParameters->result == L2CAP_ConnectionResponseCommand_Result_Success)
				{
					
					
					theirCID = rp->theParameters->destCID;
                    delete rp;
                    logLB->AddString("result success");
				    ConnectionLevel = L2CAP_Level_Configuring;

					
					//ByteArray* outBa = new ByteArrayAlloc(L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength + L2CAP_MinConfigureRequestCommandParametersLength);

					L2CAP_ConfigureRequestCommandPacket *cr = new L2CAP_ConfigureRequestCommandPacket(ourCommandIdentifier++,theirCID,0,NULL);
					//ByteArray *outBa =  new ByteArray((BYTE*)cr->theL2CAPPacket,cr->packetLength);
					SendL2CAPPacket( cr);
				//	MessageBox("Config req sent");
                    delete cr;
				};
			}
			catch(char* excpt){logLB->AddString(excpt);return;}

			;
			break;

		case L2CAP_Level_Configuring:
			try
			{	
				
				
				L2CAP_CommandPacket lpkt(ba);
				if(lpkt.theL2CAPCommand->code == L2CAP_ConfigureResponseCommandCode)
				{				
					L2CAP_ConfigureResponseCommandPacket *crs = new L2CAP_ConfigureResponseCommandPacket(ba);
					if( crs->theParameters->srcCID == ourCID && crs->theParameters->result == L2CAP_ConnectionResponseCommand_Result_Success)
					{
						delete crs;
						ourConfigureLevel = 1;

					//	MessageBox("our config req confirmed: success");
						
						if(theirConfigureLevel == 1)
						{	
							

						logLB->AddString("\nL2CAP Connection successfully established\n");
                            //this can happen at 2 places in this code!!!!!!!!!!!!!! the other is down

                              BEUS* obexop = new BEUS(UUID_OBEXObjectPush);

                            DataElement* de1;
                            DataElement* de2;

                            de1 = new DataElement(SDP_DataElementType_UUID, obexop->val ,2);
                            delete obexop;
                            de2 = new DataElement(SDP_DataElementType_DataElementSequence,(BYTE*) (de1->theDataElement),de1->wholeSize );
                            delete de1;
                            SDP_ServiceSearchRequestPDU* ssr = new SDP_ServiceSearchRequestPDU(new BEUS(SDP_TransactionID++) ,de2/*this is a DataElementSequence*/,new BEUS(1) ,0);        
                            
                            L2CAP_Packet* sendPacket = new L2CAP_Packet(theirCID, ssr->wholePDU, ssr->wholePDULength);
                            
                            SendL2CAPPacket( sendPacket);
                            
                            //MessageBox("Packet sent");

                            delete sendPacket;
                            ConnectionLevel = SDP_Level_AwaitingServiceSearchResponse;
						}					

						
						


					};
				}else
				{
				//	MessageBox("else!!!!");
					if(lpkt.theL2CAPCommand->code == L2CAP_ConfigureRequestCommandCode)
				{				
					
					
					L2CAP_ConfigureRequestCommandPacket* cr =  new L2CAP_ConfigureRequestCommandPacket(ba);
				//	MessageBox("conf req !!!!!");
					if( cr->theParameters->destCID == ourCID && cr->theParameters->Cflag == 0)
					{
						
						theirCommandIdentifier = cr->theL2CAPCommand->identifier;
						delete cr;

						//ByteArray* outBa = new ByteArrayAlloc(L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength + L2CAP_MinConfigureResponseCommandParametersLength);
					
						L2CAP_ConfigureResponseCommandPacket* crs = new L2CAP_ConfigureResponseCommandPacket(theirCommandIdentifier,theirCID,0,0,NULL);
						SendL2CAPPacket( crs);
                        delete crs;
						//MessageBox("Config response sent");

						theirConfigureLevel = 1;

						//MessageBox("their req confirmed: success");
						
						if(ourConfigureLevel == 1)
						{	
							



						
                           	logLB->AddString("\nL2CAP Connection successfully established\n");
                            //this can happen at 2 places in this code!!!!!!!!!!!!!! the other is up

                            BEUS* obexop = new BEUS(UUID_OBEXObjectPush);

                            DataElement* de1;
                            DataElement* de2;

                            de1 = new DataElement(SDP_DataElementType_UUID, obexop->val ,2);
                            delete obexop;
                            de2 = new DataElement(SDP_DataElementType_DataElementSequence,(BYTE*) (de1->theDataElement),de1->wholeSize );
                            delete de1;
                            SDP_ServiceSearchRequestPDU* ssr = new SDP_ServiceSearchRequestPDU(new BEUS((USHORT)0) ,de2/*this is a DataElementSequence*/,new BEUS(1) ,0);        
                            
                            L2CAP_Packet* sendPacket = new L2CAP_Packet(theirCID, ssr->wholePDU, ssr->wholePDULength);
                            
                            SendL2CAPPacket( sendPacket);
                            
                          //  MessageBox("Packet sent");

                            delete sendPacket;
                            ConnectionLevel = SDP_Level_AwaitingServiceSearchResponse;
						};				
						//delete cr;

						
					};
						
				
				};

				};
			
			}
			catch(char* excpt){logLB->AddString(excpt);return;}

		
			
			break;


        case SDP_Level_AwaitingServiceSearchResponse: 
            
            {  
				L2CAP_Packet* recvPacket;
				try
				{
					recvPacket = new L2CAP_Packet(ba);            
				}
				catch(char* excpt)
				{
					BEUS* obexop = new BEUS(UUID_OBEXObjectPush);

                            DataElement* de1;
                            DataElement* de2;

                            de1 = new DataElement(SDP_DataElementType_UUID, obexop->val ,2);
                            delete obexop;
                            de2 = new DataElement(SDP_DataElementType_DataElementSequence,(BYTE*) (de1->theDataElement),de1->wholeSize );
                            delete de1;
                            SDP_ServiceSearchRequestPDU* ssr = new SDP_ServiceSearchRequestPDU(new BEUS((USHORT)0) ,de2/*this is a DataElementSequence*/,new BEUS(1) ,0);        
                            
                            L2CAP_Packet* sendPacket = new L2CAP_Packet(theirCID, ssr->wholePDU, ssr->wholePDULength);
                            
                            SendL2CAPPacket( sendPacket);
                            
                          //  MessageBox("Packet sent");

                            delete sendPacket;
							return;
				}
            SDP_ServiceSearchResponsePDU* ssrsp = new SDP_ServiceSearchResponsePDU((BYTE*) (recvPacket->theL2CAPPacket->data),recvPacket->dataLength);
            USHORT retSize;
            BYTE* srhB = ssrsp->getServiceRecordHandleList(&retSize);

            BEUW* srh = new BEUW(srhB);
            //send sarq
            

            //SDP_ServiceAttributeRequestPDU(BEUS* transactionID, BEUW* ServiceRecordHandle, BEUS* MaximumAttributeByteCount,DataElement* AttributeIDList, BYTE Continuation);
    //DataElement(BYTE type, BYTE* payLoad, USHORT length);
      //  DataElement(BYTE* element, USHORT length);
    //BEUW* arange = new BEUW(0x0000ffff);


	BEUS* pdl = new BEUS(0x0004); //Request ProtocolDescriptorList

    DataElement* aidl0 = new DataElement(SDP_DataElementType_UInt, pdl->val,2);
    DataElement* aidl1 = new DataElement(SDP_DataElementType_DataElementSequence,(BYTE*) (aidl0->theDataElement),aidl0->wholeSize);

    SDP_ServiceAttributeRequestPDU* sar = new SDP_ServiceAttributeRequestPDU(new BEUS(SDP_TransactionID++), srh, new BEUS(0x063c), aidl1,0);
        
   L2CAP_Packet* sendPacket = new L2CAP_Packet(theirCID, sar->wholePDU, sar->wholePDULength);
                            
                           SendL2CAPPacket( sendPacket);
            delete sar;
            delete sendPacket;
            ConnectionLevel = SDP_Level_AwaitingServiceAttributeResponse;
            
            
            
            };
	
			break;



        case SDP_Level_AwaitingServiceAttributeResponse:
            {
			logLB->AddString("\nEntered last trap");
				L2CAP_Packet* recvPacket = new L2CAP_Packet(ba);            

            SDP_ServiceAttributeResponsePDU* ssrsp = new SDP_ServiceAttributeResponsePDU((BYTE*) (recvPacket->theL2CAPPacket->data),recvPacket->dataLength);
            DataElement *des = ssrsp->getAttributeList();
			char buff[50] = {0};
			//sprintf(buff,"%s","\nOBEX Object Push RFCOMM Channel: ");
			OBEXOPChannel = des->ExtractForRFCOMMChannel(des->theDataElement);
			sprintf(buff,"\nOBEX Object Push RFCOMM Channel: %d !!!!",OBEXOPChannel);
			logLB->AddString(buff);
			L2CAP_DisconnectRequestCommandPacket *dsc = new L2CAP_DisconnectRequestCommandPacket(ourCommandIdentifier++,theirCID,ourCID);
			SendL2CAPPacket(dsc);
			logLB->AddString("\nDisc command sent");
			ConnectionLevel = WaitingForSDP_L2CAPDiscReponse;
			};
           break;

		case WaitingForSDP_L2CAPDiscReponse:

			{logLB->AddString("\nMust have got DISC response"); 
			curL2CAPConnection = StartNewL2CAPForRFCOMM; 
			ConnectionLevel = L2CAP_Level_Start;
			theirConfigureLevel=0;
			ourConfigureLevel=0;
			
			}break;

    }


   
    
    }



	if(curL2CAPConnection == StartNewL2CAPForRFCOMM)
	{
	if(ConnectionLevel == L2CAP_Level_Start)
	{
		ourCID++;
		//ba = new ByteArrayAlloc(L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength + L2CAP_ConnectionRequestCommandParametersLength);
		L2CAP_ConnectionRequestCommandPacket lc(ourCommandIdentifier++,L2CAP_PSM_RFCOMM,ourCID);	
		ConnectionLevel = L2CAP_Level_WaitingForConResp;
        
	   SendL2CAPPacket( &lc);
		logLB->AddString("sent connreq");
	
	}
	switch (ConnectionLevel)
	{
		
		
		case L2CAP_Level_WaitingForConResp:
			//MessageBox("vfygn  1");
			try
			{
				//MessageBox("goig to intl obj");
				L2CAP_ConnectionResponseCommandPacket* rp = new L2CAP_ConnectionResponseCommandPacket(ba);
                //MessageBox("made");
				if( rp->theParameters->result == L2CAP_ConnectionResponseCommand_Result_Success)
				{
					
					theirCID = rp->theParameters->destCID;
                    delete rp;
                    logLB->AddString("result success");
				    ConnectionLevel = L2CAP_Level_Configuring;

					
					//ByteArray* outBa = new ByteArrayAlloc(L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength + L2CAP_MinConfigureRequestCommandParametersLength);

					L2CAP_ConfigureRequestCommandPacket *cr = new L2CAP_ConfigureRequestCommandPacket(ourCommandIdentifier++,theirCID,0,NULL);
					//ByteArray *outBa =  new ByteArray((BYTE*)cr->theL2CAPPacket,cr->packetLength);
                   SendL2CAPPacket( cr);
				//	MessageBox("Config req sent");
                    delete cr;
				};
			}catch(char* excpt){logLB->AddString(excpt);return;}
			break;

		case L2CAP_Level_Configuring:
		
			try
			{	
				L2CAP_CommandPacket lpkt(ba);
				if(lpkt.theL2CAPCommand->code == L2CAP_ConfigureResponseCommandCode)
				{	
					logLB->AddString("Got config resp");
					L2CAP_ConfigureResponseCommandPacket *crs = new L2CAP_ConfigureResponseCommandPacket(ba);
					if( crs->theParameters->srcCID == ourCID && crs->theParameters->result == L2CAP_ConnectionResponseCommand_Result_Success)
					{
						delete crs;
						ourConfigureLevel = 1;

					//	MessageBox("our config req confirmed: success");
						
						if(theirConfigureLevel == 1)
						{	
							

					 	logLB->AddString("\nL2CAP Connection successfully established\n");
							
                            //this can happen at 2 places in this code!!!!!!!!!!!!!! the other is up
							
							SABM_Frame* sabm = new SABM_Frame(ByteEncoder::MakeAddressStruct(1,0,0));
							//BYTE* wholePacket;
							//USHORT payLoadLength;
							L2CAP_Packet* pkt  = new L2CAP_Packet(theirCID,sabm->wholePacket, sabm->packetLength);
							SendL2CAPPacket(pkt);
							ConnectionLevel = RFCOMM_Level_SABM_Signalling_Sent;

							delete pkt;
							delete sabm;
                            //this can happen at 2 places in this code!!!!!!!!!!!!!! the other is down

                            
						}					

						
						


					};
				}else
				{
				//	MessageBox("else!!!!");
					if(lpkt.theL2CAPCommand->code == L2CAP_ConfigureRequestCommandCode)
				{				
					
					
					L2CAP_ConfigureRequestCommandPacket* cr =  new L2CAP_ConfigureRequestCommandPacket(ba);
				//	MessageBox("conf req !!!!!");
					if( cr->theParameters->destCID == ourCID && cr->theParameters->Cflag == 0)
					{
						theirCommandIdentifier = cr->theL2CAPCommand->identifier;
						delete cr;

						//ByteArray* outBa = new ByteArrayAlloc(L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength + L2CAP_MinConfigureResponseCommandParametersLength);

						L2CAP_ConfigureResponseCommandPacket* crs = new L2CAP_ConfigureResponseCommandPacket(theirCommandIdentifier,theirCID,0,0,NULL);
						SendL2CAPPacket( crs);
                        delete crs;
						//MessageBox("Config response sent");

						theirConfigureLevel = 1;

						//MessageBox("their req confirmed: success");
						
						if(ourConfigureLevel == 1)
						{	
							



						
                           	logLB->AddString("\nL2CAP Connection successfully established\n");
							//ConnectionLevel = RFCOMM_Level_SABM_Signalling_Sent;
                            //this can happen at 2 places in this code!!!!!!!!!!!!!! the other is up
							SABM_Frame* sabm = new SABM_Frame(ByteEncoder::MakeAddressStruct(1,0,0));
							//BYTE* wholePacket;
							//USHORT payLoadLength;
							//L2CAP_Packet* pkt  = new L2CAP_Packet(theirCID,sabm->wholePacket, sabm->packetLength);
							SendRFCOMMFrame(sabm);
							ConnectionLevel = RFCOMM_Level_SABM_Signalling_Sent;

							
							delete sabm;

                        
						};				
						//delete cr;

						
					};
						
				
				};

				};
			
			}catch(char* excpt){logLB->AddString(excpt);return;}
			
			break;

		case RFCOMM_Level_SABM_Signalling_Sent:
			{
				//Got UA Frame

				L2CAP_Packet pkt(ba);
				
				RFCOMM_Frame frame(pkt.theL2CAPPacket->data,pkt.dataLength);
				//char buf[30] = {0};
				//int j=0;
				//j= sprintf(buf,"DataLength: %d   ",pkt.dataLength);
				
				//for(int i=0;i<frame.packetLength;i++)
				//	j+=sprintf(buf+j,"%02x ",frame.wholePacket[i]);
					
			//	sprintf(buf,"%02x",ba->array[(ba->length)-1]);
				
			//	MessageBox(buf);

				if(*(frame.control) == Control_UA ||  *(frame.control) == Control_UA+SetPF_Factor)
					logLB->AddString("RFCOMM_Signalling_Channel Connection Established");
				else
					{
						logLB->AddString("RFCOMM_Signalling_Channel Connection Failed: Remote device refused connection...");	
						this->Disconnect();
						this->sendingFile = false;
						caller->OnSendSessionComplete(this->file, false);
					}



				PN_Command_Frame pncf(1,1,ByteEncoder::MakeAddressStruct(1,0,OBEXOPChannel),0x0695,ByteEncoder::MakeInitialCreditStruct(4));
				//L2CAP_Packet outpkt(theirCID,pncf.wholePacket, pncf.packetLength);

				logLB->AddString("PN Request Message Sent");
				SendRFCOMMFrame(&pncf);
				ConnectionLevel = RFCOMM_Level_PN_Message_Sent; //CHANGE THIS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
				
				
				//logLB->AddString(buf);
				
			}
			
			break;

		case RFCOMM_Level_PN_Message_Sent:
			{
				
			    logLB->AddString("Must have got a PN Response Message");
				L2CAP_Packet pkt(ba);				
				PN_Command_Frame frame(pkt.theL2CAPPacket->data,pkt.dataLength);

				
				this->theirMaxFrameSize = (frame.vals->MaxFrameSize - 1/*incase we use 2 bytes for the length filed*/);
				this->theirCreditToUs = frame.vals->InitialCredit;

			   //TODO: Implement saving of all channel parameters
				  //this can happen at 2 places in this code!!!!!!!!!!!!!! the other is up
				SABM_Frame* sabm = new SABM_Frame(ByteEncoder::MakeAddressStruct(1,0,OBEXOPChannel));
				//BYTE* wholePacket;
				//USHORT payLoadLength;
				//L2CAP_Packet* pkt  = new L2CAP_Packet(theirCID,sabm->wholePacket, sabm->packetLength);
				//SendHCIDataPacket(device,pkt);
				SendRFCOMMFrame(sabm);
				ConnectionLevel = RFCOMM_Level_SABM_OBEXOP_Sent;
				//delete pkt;
				delete sabm;

			}
			break;
		
		case RFCOMM_Level_SABM_OBEXOP_Sent:
			{
					L2CAP_Packet pkt(ba);				
					RFCOMM_Frame frame(pkt.theL2CAPPacket->data,pkt.dataLength);
				//char buf[30] = {0};
				//int j=0;
				//j= sprintf(buf,"DataLength: %d   ",pkt.dataLength);
				
				//for(int i=0;i<frame.packetLength;i++)
				//	j+=sprintf(buf+j,"%02x ",frame.wholePacket[i]);
					
			//	sprintf(buf,"%02x",ba->array[(ba->length)-1]);
				
			//	MessageBox(buf);

				if(*(frame.control) == Control_UA ||  *(frame.control) == Control_UA+SetPF_Factor)
				{	
					logLB->AddString("RFCOMM_OBEX Object Push_Channel Connection Established");
					MSC_Command_Frame pncf(1,1,ByteEncoder::MakeAddressStruct(1,0,OBEXOPChannel),0,1,1);
					//L2CAP_Packet pkt(theirCID,pncf.wholePacket, pncf.packetLength);
					//SendHCIDataPacket(device,&pkt);
					SendRFCOMMFrame(&pncf);
					logLB->AddString("Sent our MSC ready Command");
					ConnectionLevel = RFCOMM_Level_MSC_Sent; //NOT SENT YET (TODO)

				}else
				{
						logLB->AddString("RFCOMM_Signalling_Channel Connection Failed: Remote device refused connection...");	
						this->Disconnect();
						this->sendingFile = false;
						caller->OnSendSessionComplete(file,false);
					}
				

				
			
			
			}
			
			break;

		case RFCOMM_Level_MSC_Sent: //configuring msc
			{
				L2CAP_Packet pkt(ba);				
				MSC_Command_Frame frame(pkt.theL2CAPPacket->data,pkt.dataLength);
				
				if( frame.messageTypeStr->CR == 1)
					{
						

						logLB->AddString("Got their MSC Command");	

						MSC_Command_Frame pncf(1,0,ByteEncoder::MakeAddressStruct(1,0,OBEXOPChannel),0,1,1);
						//L2CAP_Packet pkt(theirCID,pncf.wholePacket, pncf.packetLength);
						//SendHCIDataPacket(device,&pkt);
						SendRFCOMMFrame(&pncf);

						logLB->AddString("Sent them a MSC Response");	


						//respond
						theirMSCResponded = 1;
						

					}
				else if ( frame.messageTypeStr->CR == 0)
					{
						
						logLB->AddString("They responded to our MSC Command");	

						ourMSCResponded = 1;
					};

				
				
				if(ourMSCResponded && theirMSCResponded)
				{	
					
					logLB->AddString("Data RFCOMM Channel ready for OBEX commands");
					
					//TODO: Send OBEX Connect Command
					
					OBEXConnectPacket obexpkt(Opcode_Connect,0x4000);
					CreditedDataUIH_Frame cuih(ByteEncoder::MakeAddressStruct(1,0,OBEXOPChannel), 7, (BYTE*)obexpkt.wholePacket,obexpkt.packetLength);					
					//L2CAP_Packet pkt(theirCID,cuih.wholePacket, cuih.packetLength);
					//SendHCIDataPacket(device,&pkt);
					SendOBEXPacket(&obexpkt);
//					if(file)file->Close();
				//	file = NULL;	
					startedPut = false;
					ConnectionLevel = RFCOMM_Level_OBEX_Connect_Sent;
				}
			
			
			
			
			}
			
			break;



		case RFCOMM_Level_OBEX_Connect_Sent:
			{
				L2CAP_Packet pkt(ba);
				RFCOMM_Frame rf(pkt.theL2CAPPacket->data,pkt.dataLength);
				if( (*(rf.control)) == Control_DISC || (*(rf.control)) == (Control_DISC+SetPF_Factor)  )
					{
					logLB->AddString("Got rfcomm DISC!!!");
					return;					
					}
					else
				if( *(rf.control) == (Control_UIH +SetPF_Factor) || *(rf.control) == (Control_UIH))
				{   						
						
							BYTE* pload;
							USHORT ploadLength;

							if( *(rf.control) == (Control_UIH +SetPF_Factor))	
							{
								CreditedDataUIH_Frame indatuih(pkt.theL2CAPPacket->data,pkt.dataLength);
								if(pkt.dataLength==0)//this just tells the remaining credits they have for us
								{							
									this->theirCreditToUs += *(indatuih.credit);							
									return;//this just tells the remaining credits they have for us
								}
								pload = indatuih.payLoad;
								ploadLength	  = indatuih.payLoadLength;
							}else
							{
							   NoCreditDataUIH_Frame uih(pkt.theL2CAPPacket->data,pkt.dataLength);
							   pload = uih.payLoad;
							   ploadLength	  = uih.payLoadLength;
							
							}
						
						
						
						
						OBEXPacket obexpkt (pload,ploadLength);
							//char dspbuf[50] = {0};

							//sprintf(dspbuf,"%02x",obexpkt.wholePacket->code);

							//MessageBox(dspbuf);
							if(!startedPut)
							{
									if(obexpkt.wholePacket->code == RspCode_Success)
									{
										logLB->AddString("OBEX connection successful");
										
										BEUS tmo(((BYTE*)(obexpkt.wholePacket->data))+2);					
										theirMaxOBEXPacketSize = tmo.getValUSHORT(); 
										//theirMaxOBEXPacketSize = 600;
										char buf[50] = {0};
										sprintf(buf,"Their max OBEX packet size: %d",theirMaxOBEXPacketSize);
										logLB->AddString(buf);
										
										  
										//file = new CStdioFile();
										//file->Open("card.vcf",CFile::modeRead|CFile::typeBinary);
										//file->Open("img.jpg",CFile::modeRead|CFile::typeBinary);
										//if(opc)
										//	delete opc;
										opc = new OBEXPutCommand(theirMaxOBEXPacketSize,file);							
										
										sprintf(buf,"N OBEX puts to send: %d",opc->nPacketsToSend);
										logLB->AddString(buf);
										//devicesLB->DrawAnimatedRects()

										
													OBEXPacket *obexpkt = opc->CgetNextPacket();
													SendOBEXPacket(obexpkt);					   
													delete obexpkt;
													startedPut = true;

									}

								
							}
							else
							{
									if(obexpkt.wholePacket->code == RspCode_Success)
										{
											//send obex disc
											logLB->AddString("OBEX File Sent");
											OBEXPacket dsc(Opcode_Disconnect,NULL,0);
											SendOBEXPacket(&dsc);
											logLB->AddString("OBEX Disconnect Sent");								
											ConnectionLevel = RFCOMM_Level_OBEX_File_Sent;								
											startedPut = false;
										}else
									if(obexpkt.wholePacket->code == RspCode_Continue)
										{
											OBEXPacket *obexpkt = opc->CgetNextPacket();								
											SendOBEXPacket(obexpkt);					   
											delete obexpkt;
										
										}
								
								
							}
					
					
					
					}
				
				
			};
			break;

		case RFCOMM_Level_OBEX_File_Sent:
			{
				
				L2CAP_Packet pkt(ba);
				RFCOMM_Frame rf(pkt.theL2CAPPacket->data,pkt.dataLength);
				if( (*(rf.control)) == Control_DISC || (*(rf.control)) == (Control_DISC+SetPF_Factor)  )
					{
					logLB->AddString("Got rfcomm DISC!!!");
					return;					
					}
					else
				if( *(rf.control) == (Control_UIH +SetPF_Factor) || *(rf.control) == (Control_UIH))
				{   						
						
							BYTE* pload;
							USHORT ploadLength;

							if( *(rf.control) == (Control_UIH +SetPF_Factor))	
							{
								CreditedDataUIH_Frame indatuih(pkt.theL2CAPPacket->data,pkt.dataLength);
								if(pkt.dataLength==0)//this just tells the remaining credits they have for us
								{							
									this->theirCreditToUs += *(indatuih.credit);							
									return;//this just tells the remaining credits they have for us
								}
								pload = indatuih.payLoad;
								ploadLength	  = indatuih.payLoadLength;
							}else
							{
							   NoCreditDataUIH_Frame uih(pkt.theL2CAPPacket->data,pkt.dataLength);
							   pload = uih.payLoad;
							   ploadLength	  = uih.payLoadLength;
							
							}

							OBEXPacket obexpkt (pload,ploadLength);
							if(obexpkt.wholePacket->code == RspCode_Success)
							{
								logLB->AddString("OBEX disconnected successfully.");
								DISC_Frame dsc(ByteEncoder::MakeAddressStruct(1,0,OBEXOPChannel)); 
								SendRFCOMMFrame(&dsc);
								ConnectionLevel = RFCOMM_Level_DISC_OPCH_SENT;
							}
						
					}
				
			};break;

		case  RFCOMM_Level_DISC_OPCH_SENT:
			{
			
				L2CAP_Packet pkt(ba);
				RFCOMM_Frame rf(pkt.theL2CAPPacket->data,pkt.dataLength);
			
				   if( (*(rf.control)) == (Control_UA+SetPF_Factor)  )
					{
						logLB->AddString("Got rfcomm DISC.. responding");
						if(rf.address->ServerChannel == OBEXOPChannel)
							{
								logLB->AddString("Successfully disconnected from remote OBEX OP RFCOMM channel.");
								logLB->AddString("Attemting to disconnect RFCOMM signalling channel");
								DISC_Frame dsc(ByteEncoder::MakeAddressStruct(1,0,RFCOMM_SignallingChannel)); 
								SendRFCOMMFrame(&dsc);								
								ConnectionLevel = RFCOMM_Level_DISC_SignallingCH_SENT;
							
							}
					}			
			};break;			
	  
		case  RFCOMM_Level_DISC_SignallingCH_SENT:
			{
			
				L2CAP_Packet pkt(ba);
				RFCOMM_Frame rf(pkt.theL2CAPPacket->data,pkt.dataLength);
			
				   if( (*(rf.control)) == (Control_UA+SetPF_Factor)  )
					{
						logLB->AddString("Got rfcomm DISC.. responding");
						if(rf.address->ServerChannel == RFCOMM_SignallingChannel)
							{
								logLB->AddString("Successfully disconnected from remote OBEX OP RFCOMM channel.");
								logLB->AddString("Attemting to disconnect the L2CAP for RFCOMM channel...");
								
								L2CAP_DisconnectRequestCommandPacket *dsc = new L2CAP_DisconnectRequestCommandPacket(ourCommandIdentifier++,theirCID,ourCID);
								SendL2CAPPacket(dsc);
								logLB->AddString("\nL2CAP Disc command sent");
								ConnectionLevel = L2CAP_RFCOMMPSM_DISC_SENT;
							
							}
					}			
			};break;			

		case  L2CAP_RFCOMMPSM_DISC_SENT:
			{
			   L2CAP_CommandPacket pkt(ba);
			   if(pkt.theL2CAPCommand->code == L2CAP_DisconnectResponseCommandCode)
				   {
						  logLB->AddString("Got L2CAP Disconnect success!!!");
						  this->Disconnect();	
						  logLB->AddString("Disconnected...");
						  this->sendingFile = false;
						  caller->OnSendSessionComplete(file,true);
				   }
			
			}break;
				

			}

	
	}
	}
	catch(se_translator::exception& ex)
	{	
		logLB->AddString("System Exception caught by se_translator in FileSender::InputHandler... possible input packet corruption.");
	    logLB->AddString(ex.description());		
		this->Disconnect();
		logLB->AddString("Disconnected...");
		this->sendingFile = false;
		caller->OnSendSessionComplete(file,false);
	}
	catch(char* error)
	{
		logLB->AddString("User Exception caught by normal C++ catch in FileSender::InputHandler... possible input packet corruption.");		
		this->Disconnect();
		logLB->AddString("Disconnected...");
		this->sendingFile = false;
		caller->OnSendSessionComplete(file,false);
	}
	if(ba) delete ba; 

}
    
    
    
	
	

bool FileSender::SendL2CAPPacket(L2CAP_Packet* pkt)
	{
		
		//loop
		return this->SendHCIPayload((BYTE*)pkt->theL2CAPPacket,pkt->packetLength);	
		
	}
bool  FileSender::SendL2CAPPayload(BYTE* payLoad, USHORT length)
	{
		logLB->AddString("L2CAP sender called");		
		int nToSend = (length)/theirMTU + ((length%theirMTU == 0)? 0: 1);		
		char dspBuf[50]={0};
		sprintf((char*)dspBuf,"nToSend: %d, packetLength: %d ",nToSend,length);
		logLB->AddString(dspBuf);		
		DWORD buffPos=0;
		
		for(int j=0; j<nToSend;j++)
		{		
			
			L2CAP_Packet lp(theirCID,payLoad+buffPos,( ( (length) - buffPos )>theirMTU)?theirMTU:((length) - buffPos ));
			if(!SendL2CAPPacket(&lp))
				return false;
			buffPos += ( ( (length) - buffPos )>theirMTU)?theirMTU:((length) - buffPos );
		
			
		}
		return true;
		
	
	
	}		

bool FileSender::SendRFCOMMFrame(RFCOMM_Frame* pkt)
	{
		return SendL2CAPPayload(pkt->wholePacket,pkt->packetLength);
	}
bool FileSender::SendRFCOMMData(BYTE* payLoad, USHORT length)
	{
		//Use SendCreditedRFCOMMData...
		//change naming!!! Data UIH frames can be without credits too, to other channels other than signalling

		/*logLB->AddString("RFCOMM Data sender called");		
		//this->theirMaxFrameSize tells the max payload! NOT whole packet
		int nToSend = (length)/theirMaxFrameSize + ((length%theirMaxFrameSize == 0)? 0: 1);		
		char dspBuf[50]={0};
		sprintf((char*)dspBuf,"nToSend: %d, packetLength: %d ",nToSend,length);
		logLB->AddString(dspBuf);		
		DWORD buffPos=0;
		
		for(int j=0; j<nToSend;j++)
		{		
			
			SignallingUIH_Frame du(1,payLoad+buffPos,( ( (length) - buffPos )>theirMaxFrameSize)?theirMaxFrameSize:((length) - buffPos ));			
			if(!SendRFCOMMFrame(&du))
				return false;
			buffPos += ( ( (length) - buffPos )>theirMaxFrameSize)?theirMaxFrameSize:((length) - buffPos );
		
			
		}
		return true; */
	return false;
	
	}
bool FileSender::SendCreditedRFCOMMFrame(CreditedRFCOMM_Frame* pkt)
	{
		return SendL2CAPPayload(pkt->wholePacket,pkt->packetLength);
	}
bool FileSender::SendCreditedRFCOMMData(BYTE* payLoad, USHORT length)
	{
		logLB->AddString("RFCOMM Data sender called");		
		//this->theirMaxFrameSize tells the max payload! NOT whole packet
		int nToSend = (length)/theirMaxFrameSize + ((length%theirMaxFrameSize == 0)? 0: 1);		
		char dspBuf[100]={0};
		sprintf((char*)dspBuf,"nToSend: %d, packetLength: %d\n Their MaxFrameSize = %d ",nToSend,length,theirMaxFrameSize);
		logLB->AddString(dspBuf);		
		DWORD buffPos=0;
		
		for(int j=0; j<nToSend;j++)
		{		
			
			CreditedDataUIH_Frame du(ByteEncoder::MakeAddressStruct(1,0,this->OBEXOPChannel),1/*temp...*/,payLoad+buffPos,( ( (length) - buffPos )>theirMaxFrameSize)?theirMaxFrameSize:((length) - buffPos ));			
			if(!SendCreditedRFCOMMFrame(&du))
				return false;
			buffPos += ( ( (length) - buffPos )>theirMaxFrameSize)?theirMaxFrameSize:((length) - buffPos );
		
			
		}
		return true;	
	}
bool FileSender::SendOBEXPacket(OBEXPacket* pkt)
	{
		return SendCreditedRFCOMMData((BYTE*)pkt->wholePacket,pkt->packetLength);
	}


FileSender::~FileSender(void)
	{
		
	}
