// HCIClient.cpp: implementation of the HCIClient class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
//#include "BT_Server.h"

#include "HCIServer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HCIClient::HCIClient(HCIClientCaller* caller,CListBox* lb)
{
		
	ZeroMemory(&(this->Device),sizeof(this->Device));
	this->Handle = 0;
	this->connected = false;
	this->InquiredDevices = new TidyVector();
	
	this->Server = (void*) HCIServer::getInstance(lb);
	this->caller = caller;

	//check if connected...
	//this->connected = 
	//connected = 
}

void HCIClient::OnDisconnect()
{
this->caller->OnDisconnect(this->Handle);
}
	////////////////////////////////////////////////////
	//called by HCIServer 
	
	//User functions

bool HCIClient::Connect(BTDevice dev)		//modifies Handle if successful
{
	this->Device = dev;	
	return ((HCIServer*)Server)->ConnectACL(this);
}

bool HCIClient::Disconnect()
{
	if(this->connected)
		return ((HCIServer*)Server)->Disconnect(this);
	return false;
}

bool HCIClient::SendHCIPayload(BYTE* payLoad, USHORT length)
{
	if(!connected)
		return false;
	return ((HCIServer*)Server)->SendHCIPayload(this,payLoad,length);
}
void HCIClient::HandleInput(USHORT Handle, BYTE* payLoad, USHORT length)	
{
	//YOU MUST IMPLEMENT THIS FUNCTION IN THE INHERITING CLASS
	caller->OnInput(Handle, payLoad,length);
}

void HCIClient::HandleInquiryComplete()
{
	//YOU MUST IMPLEMENT THIS FUNCTION IN THE INHERITING CLASS
	caller->OnInquiryComplete();		
		

}
bool HCIClient::DoInquiry() //result would be in the InquiredDevices vector
{
	return(((HCIServer*)Server)->DoInquiry(this));
}
BOOL HCIClient::AddressToString(BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE], CString &szAddress)
{
	szAddress.Format(_T("%02X:%02X:%02X:%02X:%02X:%02X"),
						BD_ADDR[5],
						BD_ADDR[4],
						BD_ADDR[3],
						BD_ADDR[2],
						BD_ADDR[1],
						BD_ADDR[0]);

	return TRUE;

}
	  


HCIClient::~HCIClient()
{

}

