// HCIServer.cpp: implementation of the HCIServer class.
//
//////////////////////////////////////////////////////////////////////






#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

// One of these structs is attached to each list item


/////////////////////////////////////////////////////////////////////////////
// HCIServer dialog
#include "stdafx.h"
#include "fbthci.h"
#include "fbtutil.h"
#include "HCIServer.h"
#include "se_translator.h"



typedef struct _LogItem
{
	HCIServer	*pThis;
	BOOL		bEvent;
	BYTE		*pBuffer;
	DWORD		dwLength;

} LogItem, *PLogItem;


HCIServer* HCIServer::curInstance=NULL;

HCIServer* HCIServer::getInstance(CListBox* lb)
{
			
	if(curInstance == NULL)		
		curInstance = new HCIServer(lb);
	
	return curInstance;
			
	
	
}
USHORT HCIServer::getMaxACLDataPayLoadLength()
	{
		return	this->Max_ACLDataPayLoad;
	}
HCIServer::HCIServer(CListBox *loglb/*, CListBox *devlb*/)
{
	this->LogLB = loglb;


	CFont *font=new CFont;
	font->CreateFont(
			14,                        // nHeight
			0,                         // nWidth
			0,                         // nEscapement
			0,                         // nOrientation
			0,                 // nWeight
			FALSE,                     // bItalic
			FALSE,                     // bUnderline
			FALSE,                         // cStrikeOut
			DEFAULT_CHARSET,              // nCharSet
			OUT_DEFAULT_PRECIS,        // nOutPrecision
			CLIP_DEFAULT_PRECIS,       // nClipPrecision
			DEFAULT_QUALITY,           // nQuality
			FF_DONTCARE,  // nPitchAndFamily
			"Courier New");           // lpszFacename

	LogLB->SetFont(font);

	fbtLogSetFile("bttest.log");
	fbtLogSetLevel(255);

	UINT i=0;
	CString szString;
	while (i<255 && !IsAttached())
	{
		szString.Format("\\\\.\\FbtUsb%02d", i++);
		CHciRoundTrip::Attach(szString);

	}

	if (!IsAttached())
	{
	throw ("No Bluetooth hardware detected: Please insert (or re-insert) the USB Bluetooth dongle into the USB port which the FreeBT USB Driver has been installed.");
		return;

	}

	// Retrieve the HW driver device name
	fbtLog(fbtLog_Notice, _T("HCIServer::OnInitDialog: Connected to device %s"), szString);
	char szDeviceName[80]={0};

		if (GetDeviceName(szDeviceName, 80)>0)
		loglb->AddString(szDeviceName);



	// Start listening for HCI events from the HW
	if (StartEventListener()!=ERROR_SUCCESS)
	{
		throw("Failed to start HCI Event Listener!");
		return;

	}

	// Send a reset command and wait for it to complete
	SendReset();

	// Wait a bit to make sure the device is ready...
	Sleep(1000);

	FBT_HCI_READ_LOCAL_VERSION_INFORMATION_COMPLETE CommandComplete;
	if (FBT_HCI_SUCCESS(SendReadLocalVersionInformation(CommandComplete)))
	{
		fbtLog(fbtLog_Notice, "HCI Version=%d, HCI Revsion=%d, LMP Version=%d, LMP SubVersion=%d, Manufacturer=%s",
			CommandComplete.HCIVersion,
			CommandComplete.HCIRevision,
			CommandComplete.LMPVersion,
			CommandComplete.LMPSubVersion,
			GetManufacturerName(CommandComplete.Manufacturer));

		LogLB->AddString(GetManufacturerName(CommandComplete.Manufacturer));

		CString szTemp;
		szTemp.Format("%d, %d", CommandComplete.HCIVersion, CommandComplete.HCIRevision);
		LogLB->AddString(szTemp);

		szTemp.Format("%d, %d", CommandComplete.LMPVersion, CommandComplete.LMPSubVersion);
		LogLB->AddString(szTemp);

	}

	// Make the device discoverable
	//SendWriteScanEnable(3);
	SendWriteScanEnable(0);//disable

	// Set default connect timeout
	SendWritePageTimeout(0x2000);

	// Set the the class of device
	BYTE ClassOfDeviceBytes[FBT_HCI_DEVICE_CLASS_SIZE]={0};

	// PC
	ClassOfDeviceBytes[0]=0x10;
	ClassOfDeviceBytes[1]=0x01;
	ClassOfDeviceBytes[2]=0x02;

	fbtLog(fbtLog_Notice, _T("HCIServer::OnInitDialog: Calling SendWriteClassOfDevice"));
	SendWriteClassOfDevice(ClassOfDeviceBytes);

	fbtLog(fbtLog_Notice, _T("HCIServer::OnInitDialog: Calling SendSetEventFilter"));

	// Enable connection auto-accept
	BYTE Condition[FBT_HCI_MAX_CONDITION_SIZE]={0};
	Condition[0]=2;
	SendSetEventFilter(
		FBT_HCI_FILTER_CONNECTION_SETUP,
		FBT_HCI_FILTER_ALL,
		Condition,
		1);

	// Set the Device Name
//	TCHAR szDeviceName[80]={0};
	ZeroMemory(szDeviceName, 80);
	DWORD dwLength=80;
	if (GetComputerName(szDeviceName, &dwLength))
	{
		BYTE szLocalName[FBT_HCI_NAME_SIZE]={0};
		strcpy((char*)szLocalName, szDeviceName);
		SendChangeLocalName(szLocalName);

	}

	// Read the local BD_ADDR
	BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE];
	if (ReadBDADDR(BD_ADDR)==ERROR_SUCCESS)
	{
		CString szDevice;
		szDevice.Format(_T("%02X:%02X:%02X:%02X:%02X:%02X"),
							BD_ADDR[5],
							BD_ADDR[4],
							BD_ADDR[3],
							BD_ADDR[2],
							BD_ADDR[1],
							BD_ADDR[0]);

		LogLB->AddString(szDevice);

	}

	else
		fbtLog(fbtLog_Notice, _T("HCIServer::OnInitDialog: Failed to read BDADDR"));


	//read acl packet size
	FBT_HCI_CMD_HEADER readBuffSz;
	readBuffSz.OpCode=   /*0001 00           00 0000 0101*/  0x1005;
	readBuffSz.ParameterLength = 0;
	this->Max_ACLDataPayLoad = 64; //set default
	this->SendHciCommand(&readBuffSz,sizeof(readBuffSz));
	



	// Start the reader thread
	DWORD dwThreadId=0;
	CreateThread(NULL, 0, Reader, (LPVOID)this, 0, &dwThreadId);


	
	this->HCIClients = new CPtrArray();
	this->inquiryClient = NULL;

	//	this->getNamesClient = NULL;

	//get MAXACLPACKETSIZE BY READING THE BUFFER
	this->outbox = new RoutinedVector(this);

	Sleep(1000); // to make sure we got the max hci buffer size before use

	curInstance =  this;

	




}



BOOL HCIServer::InitBT(void)
{
	return true;

}

bool HCIServer::DoInquiry(HCIClient* iqClient) 
{
	if(curInstance->inquiryClient)
		return false;// already doing an inquiry... can't do another at the same time... 

	curInstance->inquiryClient = iqClient;	 // sets the flag to NOT allow other clients to do inquiries
	
	SetCursor(LoadCursor(NULL, IDC_WAIT));
	//DevicesLB->ResetContent();
	iqClient->InquiredDevices->RemoveAll(); //Do inquiry only when there's no on going sessions
	curInstance->SendInquiry(FBT_HCI_LAP_GIAC, 5, 0);

	return true;
}




bool HCIServer::BD_Addr_Equal(BYTE BD_ADDR1[FBT_HCI_BDADDR_SIZE],BYTE BD_ADDR2[FBT_HCI_BDADDR_SIZE])
{
	for(int i=0;i<FBT_HCI_BDADDR_SIZE;i++)
		if(BD_ADDR1[i] != BD_ADDR2[i])
			return false;
	return true;

}

bool HCIServer::ConnectACL(HCIClient *connectClient) 
{
	
	if(connectClient->connected==true)
		return false;
	
	USHORT ConnectionHandle=0;	
	DWORD dwReturn=CreateConnection(
						connectClient->Device.BD_ADDR,
						FBT_HCI_PACKET_TYPE_ALL,
						connectClient->Device.PageScanRepetitionMode,
						connectClient->Device.PageScanMode,
						connectClient->Device.ClockOffset,
						TRUE,
						connectClient->Handle); //CreateConnection(..., USHORT &ConnectionHandle) This would modify and return the connection handle in the HCIClient automatically

		CString szMsg;
		if (FBT_HCI_SUCCESS(dwReturn))
		{
			this->HCIClients->Add(  connectClient  );
			szMsg.Format("Connected on handle 0x%04x", connectClient->Handle);
			LogLB->AddString(szMsg);
			connectClient->connected = true;
			return true;// success in connection
			            
		}

		else
		{
			szMsg.Format("Connect failed (%s)", GetStatusText((BYTE)dwReturn));
			LogLB->AddString(szMsg);
			return false;
		}

	
	
}
bool HCIServer::Disconnect(HCIClient* disconnectClient)
{
		CString szMsg;
	
		if (FBT_HCI_SUCCESS(CHciRoundTrip::Disconnect(
				disconnectClient->Handle,
								FBT_HCI_REMOTE_USER_TERMINATED_CONNECTION)))
		{
			szMsg.Format("Disconnect on handle 0x%04x success", disconnectClient->Handle);	
			LogLB->AddString(szMsg);
			disconnectClient->connected = false;
			
			for(int i=0;i<this->HCIClients->GetSize();i++)
			{
				if(   ((HCIClient*)HCIClients->GetAt(i)) == disconnectClient   )
					{
						
						HCIClients->RemoveAt(i); //auto delete in TidyVector
						break; //this handle should be unique

					}
			}		
			
			return true;
		}
		else
		{			
			szMsg.Format("Disconnect on handle 0x%04x failed", disconnectClient->Handle);		
			LogLB->AddString(szMsg);
			return false;		
		}
}
bool HCIServer::SendHCIPayload(HCIClient* sendClient,BYTE* payLoad, USHORT length) //called by in-door HCIClients
{
	
		LogLB->AddString("HCI sender called");
		// Allocate a data packet with enough space
		//HCI packet is 64 bytes and the HCI Header takes up 4 bytes to there's Max_ACLPacketSize bytes payLoad for a HCI data packet
		int nToSend = (length)/Max_ACLDataPayLoad + (  (length%Max_ACLDataPayLoad == 0)? 0: 1   );		
		char dspBuf[50]={0};
		sprintf((char*)dspBuf,"nToSend: %d, packetLength: %d ",nToSend,length);
		LogLB->AddString(dspBuf);		
		DWORD buffPos=0;
		
		for(int j=0; j<nToSend;j++)
		{		
			USHORT packetSize = HCIDataPacketHeaderSize+ (( ( (length) - buffPos )>Max_ACLDataPayLoad)?Max_ACLDataPayLoad:((length) - buffPos ));
			PFBT_HCI_DATA_PACKET pData=(PFBT_HCI_DATA_PACKET)malloc(packetSize);
			memset(pData, 0, packetSize);
			pData->ConnectionHandle = sendClient->Handle;
			pData->DataLength = (packetSize - HCIDataPacketHeaderSize);
			pData->Broadcast=FBT_HCI_BROADCAST_POINT_TO_POINT;
			if(j==0)
				pData->PacketBoundary=FBT_HCI_PACKET_BOUNDARY_START;
			else
				pData->PacketBoundary=FBT_HCI_PACKET_BOUNDARY_FRAGMENT;
			LogLB->AddString("HCI data Header made");
			char dspBuf[50]={0};
			sprintf((char*)dspBuf,"data length: %d , packetSz: %d ",pData->DataLength,packetSize);
			LogLB->AddString(dspBuf);
			for(int w=0;w<pData->DataLength;w++)
				*(pData->Data + w) = *(((BYTE *)payLoad)+w+buffPos);			
			LogLB->AddString("Body copied");			
			buffPos+=pData->DataLength;
			
			this->outbox->Add(pData);			
			/*DWORD dwBytesWritten=0;
			if (SendData(pData, packetSize, &dwBytesWritten, NULL)==ERROR_SUCCESS)
			{
					char szBuffer[1024]={0};
					char szBufferShort[20]={0};

					sprintf(szBuffer, "W: ");
					for (DWORD k=0; k<dwBytesWritten; k++)
					{
						sprintf(szBufferShort, "%02x ", ((PBYTE)pData)[k]);
						strcat(szBuffer, szBufferShort);
					}
					LogLB->AddString(szBuffer);
			
					fbtLog(fbtLog_Verbose, "CBTTestDlg::SendData: written %d bytes: %s", dwBytesWritten,szBuffer );            
			}
			else
				{LogLB->AddString("Send failed");free(pData);break;}
			free(pData);*/
		}
	
	return TRUE;
}
void HCIServer::DistributeDataPacket(PFBT_HCI_DATA_PACKET pData) //called by reader, send to in-door HCIClients
{
try{ 
	for(int i=0;i<this->HCIClients->GetSize();i++)
			{
					if(   ((HCIClient*)HCIClients->GetAt(i))->Handle == pData->ConnectionHandle)
					{
						
						
						
						//FUTURE ************ Remember to do re-assembly of the fragments!
						((HCIClient*)HCIClients->GetAt(i))->HandleInput(pData->ConnectionHandle, pData->Data, pData->DataLength);						
						break; //this handle should be unique

					}
			}	
	}catch(se_translator::exception& ex)
	{	
		LogLB->AddString("Exception in HCIServer::DistributeDataPacket... Failed to send packet to it's handler.");
	    LogLB->AddString(ex.description());				
	}
}
DWORD HCIServer::OnInquiryComplete(BYTE Status, BYTE NumResponses)
{
	SetCursor(LoadCursor(NULL, IDC_ARROW));
	if (Status!=0)
		LogLB->AddString("Inquiry failed");		

	else
		{
			LogLB->AddString("Inquiry complete");
			this->inquiryClient->HandleInquiryComplete();
		}

	this->inquiryClient = NULL;	// clears the flag to allow other clients to do inquiries

	return 0;

}

DWORD HCIServer::OnInquiryResult(BYTE NumResponses, BYTE BD_ADDR[FBT_HCI_VARIABLE_SIZE][FBT_HCI_BDADDR_SIZE], BYTE PageScanRepetitionMode[FBT_HCI_VARIABLE_SIZE], BYTE PageScanPeriodMode[FBT_HCI_VARIABLE_SIZE], BYTE PageScanMode[FBT_HCI_VARIABLE_SIZE], BYTE ClassOfDevice[FBT_HCI_VARIABLE_SIZE][FBT_HCI_DEVICE_CLASS_SIZE], USHORT ClockOffset[FBT_HCI_VARIABLE_SIZE])
{
	CString		szDevice;
	int			nListItem=0;
	PBTDevice	pBTDevice=NULL;
	
	for (UINT i=0; i<NumResponses; i++)
		{
				pBTDevice=(PBTDevice)malloc(sizeof(BTDevice));
				memset(pBTDevice, 0, sizeof(BTDevice));

				memcpy(pBTDevice->BD_ADDR, BD_ADDR[i], FBT_HCI_BDADDR_SIZE);
				memcpy(pBTDevice->ClassOfDevice, ClassOfDevice[i], FBT_HCI_DEVICE_CLASS_SIZE);

				pBTDevice->ClockOffset=ClockOffset[i];
				pBTDevice->PageScanMode=PageScanMode[i];
				pBTDevice->PageScanPeriodMode=PageScanPeriodMode[i];
				pBTDevice->PageScanRepetitionMode=PageScanRepetitionMode[i];
				
				
				
						if(this->inquiryClient)
							this->inquiryClient->InquiredDevices->Add(pBTDevice);
				
		}
		
		
		
	

	return 0;

}


DWORD CALLBACK LogItemHandler(LPVOID lpParameter)
{
	PLogItem pLogItem=(PLogItem)lpParameter;

	char szBuffer[1024]={0};
	char szBufferShort[10]={0};

	if (pLogItem->bEvent)
		sprintf(szBuffer, "E: ");

	else
		sprintf(szBuffer, "C: ");

	for (DWORD i=0; i<pLogItem->dwLength; i++)
	{
		sprintf(szBufferShort, "%02x ", pLogItem->pBuffer[i]);
		strcat(szBuffer, szBufferShort);

	}

	pLogItem->pThis->LogLB->AddString(szBuffer);

	free(pLogItem->pBuffer);
	free(pLogItem);

	return 0;

}

DWORD HCIServer::OnDisconnectionComplete(BYTE Status, USHORT ConnectionHandle, BYTE Reason)
	{
	this->LogLB->AddString("Entered HCIServer::OnDisconnectionComplete");
		for(int i=0;i<this->HCIClients->GetSize();i++)
			if(((HCIClient*) HCIClients->GetAt(i))->Handle == ConnectionHandle)
			{
				((HCIClient*) HCIClients->GetAt(i))->connected= false;				
				HCIClients->RemoveAt(i);
				this->LogLB->AddString("Found and removed the HCIClient from HCIServer::OnDisconnectionComplete");
			}
		
		return ERROR_SUCCESS;
	
	}
// Hook the Event handler so that we can log events
DWORD HCIServer::OnEvent(PFBT_HCI_EVENT_HEADER pEvent, DWORD Length)
{
	// This isn't particularly efficient, but this is just a test app...

	// Spin a thread to handle processing the event,
	// otherwise we'll hang up the dialog
	PLogItem pLogItem=new LogItem;
	pLogItem->pThis=this;
	pLogItem->bEvent=TRUE;
	pLogItem->pBuffer=(BYTE*)malloc(Length);
	memcpy(pLogItem->pBuffer, pEvent, Length);
	pLogItem->dwLength=Length;

	DWORD dwThreadId=0;
	CreateThread(NULL, 0, LogItemHandler, pLogItem, 0, &dwThreadId);

	if(pEvent->EventCode == 0x0e/*command complete*/ && pEvent->ParameterLength == 0x0b)
		{
		
			PFBT_HCI_COMMAND_COMPLETE pp = (PFBT_HCI_COMMAND_COMPLETE) pEvent;
			
			if(pp->OpCode == 0x1005) //Get buffer size...
				{
				
				 if(*((BYTE*)((pp->Parameters) + 0)) == 0/*success*/)
					 {
					 this->Max_ACLDataPayLoad = *((USHORT*)((pp->Parameters) + 1));
					 this->Max_SCODataPayLoad = *((BYTE*)((pp->Parameters) + 3));
					 this->MAXACLPacketsInBuff = *((USHORT*)((pp->Parameters) + 4));
					 this->MAXSCOPacketsInBuff = *((USHORT*)((pp->Parameters) + 6));
					 }
				  
				
				}		
		}else
		if(pEvent->EventCode == 0x13/*packet sent complete*/)
		{
		
		 this->outbox->OnEventPktComplete();
		}	

	// Let the superclass do the actual handling
	return CHciRoundTrip::OnEvent(pEvent, Length);

}

// Hook SendHciCommand, so that we can log the commands
DWORD HCIServer::SendHciCommand(PFBT_HCI_CMD_HEADER lpCommand, DWORD dwBufferSize)
{
	// This isn't particularly efficient, but this is just a test app...

	// Spin a thread to handle processing the event,
	// otherwise we'll hang up the dialog
	PLogItem pLogItem=new LogItem;
	pLogItem->pThis=this;
	pLogItem->bEvent=FALSE;
	pLogItem->pBuffer=(BYTE*)malloc(dwBufferSize);
	memcpy(pLogItem->pBuffer, lpCommand, dwBufferSize);
	pLogItem->dwLength=dwBufferSize;

	DWORD dwThreadId=0;
	CreateThread(NULL, 0, LogItemHandler, pLogItem, 0, &dwThreadId);

	// Let the superclass do the actual handling
	return CHciLocal::SendHciCommand(lpCommand, dwBufferSize);

}




DWORD CALLBACK HCIServer::Reader(LPVOID lpParameter)
{
	FBT_TRY

	HCIServer *pThis=(HCIServer*)lpParameter;

	

	char szMsg[256]={0};
	char szBuf[50]={0};

	DWORD i;
	while (true)
	{
		
		pThis->dwBytesRead=0;
		if (pThis->GetData(pThis->pBuffer, 1024, &pThis->dwBytesRead, NULL)==ERROR_SUCCESS)
		{
			fbtLog(fbtLog_Verbose, "HCIServer::Reader: Read %d bytes", pThis->dwBytesRead);
			if (pThis->dwBytesRead>0)
			{
				sprintf(szMsg, "R: ");
				for (i=0; i<pThis->dwBytesRead; i++)
				{
					sprintf(szBuf, "%02x ", ((PBYTE)pThis->pBuffer)[i]);
					strcat(szMsg, szBuf);

				}

				if (pThis->dwBytesRead>=sizeof(FBT_HCI_DATA_PACKET))
				{
					PFBT_HCI_DATA_PACKET pData=(PFBT_HCI_DATA_PACKET)pThis->pBuffer;

					fbtLog(fbtLog_Verbose, "HCIServer::Reader: %d bytes ACL data on ConnectionHandle %02x", pData->DataLength, pData->ConnectionHandle);
					pThis->LogLB->AddString(szMsg);
					pThis->DistributeDataPacket(pData);	
					

				}

				else
				{
					fbtLog(fbtLog_Failure, "HCIServer::Reader: Not enough data for a valida ACL packet");

				}

				
				fbtLog(fbtLog_Verbose, "HCIServer::Reader: %s", szMsg);


			}

			else
			{
				fbtLog(fbtLog_Failure, "HCIServer::Reader: 0 bytes read");

			}

		}

		else
			fbtLog(fbtLog_Failure, "HCIServer::Reader: GetData failed");


	}

	return 0;

	FBT_CATCH_RETURN(0)

} 
DWORD HCIServer::OnPINCodeRequest(BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE])
	{
		LogLB->AddString("Got PIN code request!");
		return CHci::SendPINCodeRequestReply(BD_ADDR, 4,(BYTE*) "1234");
		
	}

bool HCIServer::Shutdown()
	{
		if(curInstance)
			delete curInstance;
		else
			return false;
		
		curInstance = NULL;
		return true;
	}
HCIServer::~HCIServer()
{
		
		//make a new thread to disconnect in future...
		if(this->HCIClients->GetSize()!=0)
		{
			//if not empty then send disc commands to all then remove all
			
			for(int i=0;i<HCIClients->GetSize();i++)
				((HCIClient*)HCIClients->GetAt(i))->Disconnect();						
			//On event disconnect would remove the remaining clients from the CPtrArray 1 by 1 as the disconnect events come...
		}
			
			this->StopEventListener();
			this->curInstance = NULL;			
			if(this->HCIClients->GetSize()!=0)// incase some remain...			
				this->HCIClients->RemoveAll();
			delete this->HCIClients;			
			
		

}