#include "stdafx.h"
#include ".\l2capclient.h"
#include "l2capserver.h"


L2CAPClient::L2CAPClient(L2CAPClientCaller* caller, CListBox* lb)
{
	this->caller =  caller;	
    this->logLB = lb;
	this->l2server = (DWORD) L2CAPServer::getInstance(lb);
}
bool L2CAPClient::connect(BTDevice dev,BYTE PSM)
{
	return ( (L2CAPServer*) l2server)->ConnectAndConfig(this,dev,PSM);
}
bool L2CAPClient::disconnect(bool disconnectHCI)
{
	return ((L2CAPServer*)l2server)->Disconnect(this,disconnectHCI);

}
bool L2CAPClient::SendL2CAPPacket(L2CAP_Packet* pkt)
{
  return ((L2CAPServer*)l2server)->SendL2CAPPacket(this, pkt);

}
bool L2CAPClient::SendL2CAPPayload(BYTE* payLoad, USHORT length)
{
	return ((L2CAPServer*)l2server)->SendL2CAPPayload(this,payLoad,length);


}		
void L2CAPClient::OnL2CAPDataInput(L2CAPClient* client, BYTE* payLoad, USHORT length)
{

	  caller->OnL2CAPDataInput((DWORD)client,payLoad,length);


}

void L2CAPClient::OnDisconnected()
{      
	caller->OnL2CAPDisconnected(this->PSM,this->ourCID,(DWORD)this,false);
	//false???
}
		
L2CAPClient::~L2CAPClient(void)	
{



}
