/*

L2CAPConnection.cpp

Using the Bluetooth 1.1 specification.

By Kasidit Yusuf
Copyright (c) 2004 Kasidit Yusuf. All Rights Reserved.


*/


//ALL FUNCTIONS MUST NOT DELETE OBJECTS THAT DON'T BELONG TO THEM.

//AND ALL FUNCTIONS MUST KNOW THAT OTHER'S OBJECTS, ESPECIALLY WHICH THE POINTER 
//PARAMETERS THRY GOT POINT TO, CAN BE GONE ANY TIME.

//DONOT PASS OBECTS IN A NESTED WAY (EG.,   F(G());   , where G returns an object 
//which F will use as a parameter)
//BECAUSE YOU WON'T HAVE ANY POINTER TO DELETE IT
//DO NOT DO POINTER ARITHMETICS WITH THE NON-BYTE POINTERS TO AVOID OBJECT SIZE CONFUSION ERRORS

#include "stdafx.h"
#include "L2CAPConnection.h"
#include "BT_Exceptions.h"

#include "ByteArray.h"

L2CAP_Packet::L2CAP_Packet(USHORT CID, int payloadLength) //used by inherited classes to create L2CAPCommands for sending out. Only the classes at the end will do the memory allocation,not here;
{
	
	this->allocatedOwnPacket = 1;


	this->theL2CAPPacket = (L2CAP_PacketStruct) new BYTE[payloadLength + L2CAP_PacketHeaderLength];
	this->theL2CAPPacket->length = payloadLength;
	this->theL2CAPPacket->CID = CID;
	this->packetLength = payloadLength + L2CAP_PacketHeaderLength;
    this->dataLength = payloadLength;


	

};

L2CAP_Packet::L2CAP_Packet(USHORT CID, BYTE* payLoad, int payLoadLength)
{
    this->allocatedOwnPacket = 1;


	this->theL2CAPPacket = (L2CAP_PacketStruct) new BYTE[payLoadLength + L2CAP_PacketHeaderLength];
	this->theL2CAPPacket->length = payLoadLength;
	this->theL2CAPPacket->CID = CID;
	this->packetLength = payLoadLength + L2CAP_PacketHeaderLength;
    this->dataLength = payLoadLength;

	__try{
			for(int i=0; i<payLoadLength; i++)
            (this->theL2CAPPacket->data)[i] = payLoad[i];
		 }
	  __except(1)
		  {
			throw L2CAP_PacketContructorPayLoadMemoryAccessViolationException;
		  }

};
L2CAP_Packet::L2CAP_Packet(ByteArray* wholePacket) 
{
	
	
	if(wholePacket->length <= L2CAP_PacketHeaderLength) 		
		{
			throw L2CAP_PacketTooSmallException;
			return;
		}
	
    this->allocatedOwnPacket = 0;
	this->theL2CAPPacket = (L2CAP_PacketStruct) wholePacket->array;
	this->packetLength = wholePacket->length;

	if(packetLength != (theL2CAPPacket->length + L2CAP_PacketHeaderLength))
		{throw L2CAP_InvalidLengthException; return;}

    this->dataLength = wholePacket->length - L2CAP_PacketHeaderLength;

};
	
	





L2CAP_CommandPacket::L2CAP_CommandPacket(BYTE code, BYTE identifier,int parametersLength) : L2CAP_Packet(L2CAP_SignallingCID, parametersLength+L2CAP_CommandHeaderLength) //see diagram
{
		
	
	


	this->theL2CAPCommand = (L2CAP_CommandStruct)( ((BYTE*)this->theL2CAPPacket)+L2CAP_PacketHeaderLength);
	
	this->theL2CAPCommand->code = code;
	this->theL2CAPCommand->identifier = identifier;
	this->theL2CAPCommand->length = this->theL2CAPPacket->length - L2CAP_CommandHeaderLength;



	printf("\n\ncode %d\n\n",code);

};

L2CAP_CommandPacket::L2CAP_CommandPacket(ByteArray* wholePacket) : L2CAP_Packet(wholePacket)
{
	//super's verifier called by super's constructor
	if(wholePacket->length <= L2CAP_CommandHeaderLength+L2CAP_PacketHeaderLength)
			{   				
				throw L2CAP_CommandPacketTooSmallException;				
				return;
			} 
		
	if(((L2CAP_PacketStruct) wholePacket->array)->CID != L2CAP_SignallingCID)				
			{	
				
				throw L2CAP_CommandPacketCIDIsNotTheSignallingCIDException;
				return;
			}
	
	this->theL2CAPCommand = (L2CAP_CommandStruct) ((wholePacket->array)+L2CAP_PacketHeaderLength);

};




L2CAP_DisconnectRequestCommandPacket::L2CAP_DisconnectRequestCommandPacket(BYTE identifier,USHORT destCID,USHORT srcCID):L2CAP_CommandPacket(L2CAP_DisconnectRequestCommandCode,identifier,L2CAP_DisconnectRequestCommandParametersLength)
{
	this->theParameters = (L2CAP_DisconnectRequestCommandParametersStruct) (((BYTE*)this->theL2CAPPacket) + L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength);	
	((L2CAP_DisconnectRequestCommandParametersStruct)this->theParameters)->DestCID = destCID;	
	((L2CAP_DisconnectRequestCommandParametersStruct)this->theParameters)->SrcCID = srcCID;	
};

L2CAP_DisconnectResponseCommandPacket::L2CAP_DisconnectResponseCommandPacket(BYTE identifier,USHORT destCID,USHORT srcCID):L2CAP_CommandPacket(L2CAP_DisconnectResponseCommandCode,identifier,L2CAP_DisconnectResponseCommandParametersLength)
{
	this->theParameters = (L2CAP_DisconnectResponseCommandParametersStruct) (((BYTE*)this->theL2CAPPacket) + L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength);	
	((L2CAP_DisconnectResponseCommandParametersStruct)this->theParameters)->DestCID = destCID;	
	((L2CAP_DisconnectResponseCommandParametersStruct)this->theParameters)->SrcCID = srcCID;	
};










L2CAP_ConnectionRequestCommandPacket::L2CAP_ConnectionRequestCommandPacket(BYTE identifier,USHORT PSM,USHORT srcCID):L2CAP_CommandPacket(L2CAP_ConnectionRequestCommandCode,identifier,L2CAP_ConnectionRequestCommandParametersLength)
{
	
	this->theParameters = (L2CAP_ConnectionRequestCommandParametersStruct) (((BYTE*)this->theL2CAPPacket) + L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength);	
	this->theParameters->PSM = PSM;	
	this->theParameters->srcCID = srcCID;	
	
};
L2CAP_ConnectionRequestCommandPacket::L2CAP_ConnectionRequestCommandPacket(ByteArray* wholePacket) : L2CAP_CommandPacket(wholePacket)
{
		
	this->theParameters = (L2CAP_ConnectionRequestCommandParametersStruct) (((BYTE*)this->theL2CAPPacket)+L2CAP_PacketHeaderLength+L2CAP_CommandHeaderLength);

};





L2CAP_ConnectionResponseCommandPacket::L2CAP_ConnectionResponseCommandPacket(BYTE identifier,USHORT destCID,USHORT srcCID,USHORT result,USHORT status):L2CAP_CommandPacket(L2CAP_ConnectionResponseCommandCode,identifier,L2CAP_ConnectionResponseCommandParametersLength)
{
	
	this->theParameters = (L2CAP_ConnectionResponseCommandParametersStruct)(((BYTE*)this->theL2CAPPacket) + L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength);	
	this->theParameters->destCID = destCID;	
	this->theParameters->srcCID = srcCID;	
	this->theParameters->result = result;
	this->theParameters->status = status;

	
};
L2CAP_ConnectionResponseCommandPacket::L2CAP_ConnectionResponseCommandPacket(ByteArray* wholePacket) : L2CAP_CommandPacket(wholePacket)
{
	
	this->theParameters = (L2CAP_ConnectionResponseCommandParametersStruct) ((wholePacket->array)+L2CAP_PacketHeaderLength+L2CAP_CommandHeaderLength);

};


L2CAP_ConfigureRequestCommandPacket::L2CAP_ConfigureRequestCommandPacket(BYTE identifier, USHORT destCID,USHORT Cflag,ByteArray* options):L2CAP_CommandPacket(L2CAP_ConfigureRequestCommandCode,identifier,L2CAP_MinConfigureRequestCommandParametersLength+((options)?(options->length):0))//used for outgoing packets
{
	this->theParameters = (L2CAP_ConfigureRequestCommandParametersStruct)(((BYTE*)this->theL2CAPPacket) + L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength);	
	this->theParameters->destCID = destCID;
	
	this->theParameters->Cflag = Cflag;
	this->theParameters->reserved = 0; //reserved flags must be cleared


	if(options) // if there are options
		for(int i=options->length;i>=0;i--)
			*(((BYTE*)this->theParameters->Cflag) + sizeof(USHORT) + i) = options->array[i];

};


L2CAP_ConfigureRequestCommandPacket::L2CAP_ConfigureRequestCommandPacket(ByteArray *wholePacket): L2CAP_CommandPacket(wholePacket)
{	
	
	this->theParameters = (L2CAP_ConfigureRequestCommandParametersStruct) ((wholePacket->array)+L2CAP_PacketHeaderLength+L2CAP_CommandHeaderLength);

};


L2CAP_ConfigureResponseCommandPacket::L2CAP_ConfigureResponseCommandPacket(BYTE identifier, USHORT srcCID,USHORT Cflag,USHORT result,ByteArray* options):L2CAP_CommandPacket(L2CAP_ConfigureResponseCommandCode,identifier,L2CAP_MinConfigureResponseCommandParametersLength+((options)?(options->length):0))//used for outgoing packets
{
	this->theParameters = (L2CAP_ConfigureResponseCommandParametersStruct)(((BYTE*)this->theL2CAPPacket) + L2CAP_PacketHeaderLength + L2CAP_CommandHeaderLength);	
	this->theParameters->srcCID = srcCID;
	this->theParameters->Cflag = Cflag;
	this->theParameters->reserved = 0; //reserved flags must be cleared
	this->theParameters->result = result;
	
	//Add Exception handling!!!!

	if(options) // if there are options
		for(int i=options->length;i>=0;i--)
				*(((BYTE*)this->theParameters->result) + sizeof(result) + i) = options->array[i];
			
};


L2CAP_ConfigureResponseCommandPacket::L2CAP_ConfigureResponseCommandPacket(ByteArray *wholePacket): L2CAP_CommandPacket(wholePacket) //used for incoming packets
{	
	
	this->theParameters = (L2CAP_ConfigureResponseCommandParametersStruct) ((wholePacket->array)+L2CAP_PacketHeaderLength+L2CAP_CommandHeaderLength);
};



