#include "stdafx.h"
#include ".\l2capserver.h"

L2CAPServer* L2CAPServer::curInstance = NULL;

L2CAPServer::L2CAPServer(CListBox *lb)
	{
	
		this->logLB = lb;
		this->prevCID = 0x0040;
		this->ourMTU = 672; //default
		

	}

bool L2CAPServer::ConnectAndConfig(L2CAPClient* caller,BTDevice dev,BYTE PSM)
	{
		bool found = false;		
		for(int i=0; i<this->SourceHCIClients.GetSize();i++)		
			if(  strncmp((char*)((HCIClient*)SourceHCIClients.GetAt(i))->Device.BD_ADDR ,(char*) dev.BD_ADDR, 6)==0)
				{	
					found = true;
				    if(((HCIClient*)SourceHCIClients.GetAt(i))->connected == true || ((HCIClient*)SourceHCIClients.GetAt(i))->Connect(dev))
						{
							caller->ConnectionLevel=L2CAP_Level_Start;
							caller->theirConfigureLevel=0;
							caller->ourConfigureLevel=0;
							caller->ourCommandIdentifier=1;
							caller->theirCommandIdentifier=1;
							
							caller->ourCID = (this->prevCID >= 0x0040 && this->prevCID < 0xffff) ? this->prevCID+1 : 0x0040;

							L2CAP_ConnectionRequestCommandPacket lc(caller->ourCommandIdentifier++,caller->PSM,caller->ourCID);	
							
							
							this->SendL2CAPPacket(caller, &lc);
							logLB->AddString("l2 conn sent!");
							caller->ConnectionLevel++;			
							//PBTDevice pBTDevice=(PBTDevice) m_lbDevices.GetItemData(nDevice);	
							//SendHCIDataPacket(pBTDevice, &lc);
							//Handle input will handle the rest
							return true;
			
						}
				}
			
			return false;
			
			
	}
bool L2CAPServer::Disconnect(L2CAPClient* caller, bool dhci)
	{
		

	
	for(int i=0;i< L2CAPClients.GetSize();i++)
			if(caller == L2CAPClients.GetAt(i))
				L2CAPClients.RemoveAt(i);
		if(dhci)
			return caller->HCI_Client->Disconnect();

		return true;
	}

bool L2CAPServer::SendL2CAPPacket(L2CAPClient *caller, L2CAP_Packet* pkt)
	{
		
		//loop
		return caller->HCI_Client->SendHCIPayload((BYTE*)pkt->theL2CAPPacket,pkt->packetLength);	
		
	}

bool  L2CAPServer::SendL2CAPPayload(L2CAPClient *caller,BYTE* payLoad, USHORT length)
	{
		logLB->AddString("L2CAP sender called");		
		int nToSend = (length)/(caller->theirMTU) + ((length%(caller->theirMTU) == 0)? 0: 1);		
		char dspBuf[50]={0};
		sprintf((char*)dspBuf,"nToSend: %d, packetLength: %d ",nToSend,length);
		logLB->AddString(dspBuf);		
		DWORD buffPos=0;
		
		for(int j=0; j<nToSend;j++)
		{		
			
			L2CAP_Packet lp(caller->theirCID,payLoad+buffPos,( ( (length) - buffPos )>(caller->theirMTU))?(caller->theirMTU):((length) - buffPos ));
			if( !caller->HCI_Client->SendHCIPayload((BYTE*)lp.theL2CAPPacket,lp.packetLength) )
				return false;
			buffPos += ( ( (length) - buffPos )>(caller->theirMTU))?(caller->theirMTU):((length) - buffPos );
		
			
		}
		return true;
		
	
	
	}			
void L2CAPServer::OnInput(USHORT handle, BYTE* payLoad, USHORT length)
	{
		 L2CAP_Packet pkt;
		 ByteArray ba(payLoad, length);
		
		 L2CAPClient* client = NULL;
		  
		 for(int x=0;x<L2CAPClients.GetSize();x++)
			if(((L2CAPClient*)L2CAPClients.GetAt(x))->HCI_Client->Handle == handle)
				{	client = ((L2CAPClient*)L2CAPClients.GetAt(x));break;}


		 if(!client)
			 return;

		 if(pkt.theL2CAPPacket->CID == L2CAP_SignallingCID)
			 {
				switch (client->ConnectionLevel)
				{				
					case L2CAP_Level_WaitingForConResp:					
					try
					{					
						
						L2CAP_ConnectionResponseCommandPacket rp(&ba);
						if( rp.theParameters->result == L2CAP_ConnectionResponseCommand_Result_Success)
						{
							
							
							client->theirCID = rp.theParameters->destCID;							
							logLB->AddString("result success");
							client->ConnectionLevel = L2CAP_Level_Configuring;

							
							

							L2CAP_ConfigureRequestCommandPacket *cr = new L2CAP_ConfigureRequestCommandPacket(client->ourCommandIdentifier++,client->theirCID,0,NULL);
							
							client->SendL2CAPPacket( cr);
						//	
							delete cr;
						};
					}
					catch(char* excpt){logLB->AddString(excpt);return;}

					;
					break;

				case L2CAP_Level_Configuring:
					try
					{	
						
						
						L2CAP_CommandPacket lpkt(&ba);
						if(lpkt.theL2CAPCommand->code == L2CAP_ConfigureResponseCommandCode)
						{				
							L2CAP_ConfigureResponseCommandPacket *crs = new L2CAP_ConfigureResponseCommandPacket(&ba);
							if( crs->theParameters->srcCID == client->ourCID && crs->theParameters->result == L2CAP_ConnectionResponseCommand_Result_Success)
							{
								delete crs;
								client->ourConfigureLevel = 1;

			
								
								if(client->theirConfigureLevel == 1)
								{	
									
	
									logLB->AddString("\nL2CAP Connection successfully established\n");
									//this can happen at 2 places in this code!!!!!!!!!!!!!! the other is down

									client->ConnectionLevel = L2CAP_Level_Configured;
								}					

								
								


							};
						}else
						{
						
							if(lpkt.theL2CAPCommand->code == L2CAP_ConfigureRequestCommandCode)
						{				
							
							
							L2CAP_ConfigureRequestCommandPacket* cr =  new L2CAP_ConfigureRequestCommandPacket(&ba);
						
							if( cr->theParameters->destCID == client->ourCID && cr->theParameters->Cflag == 0)
							{
								
								client->theirCommandIdentifier = cr->theL2CAPCommand->identifier;
								delete cr;

						
							
								L2CAP_ConfigureResponseCommandPacket* crs = new L2CAP_ConfigureResponseCommandPacket(client->theirCommandIdentifier,client->theirCID,0,0,NULL);
								client->SendL2CAPPacket( crs);
								delete crs;
						

								client->theirConfigureLevel = 1;

																
								if(client->ourConfigureLevel == 1)
								{	
									



								
                           			logLB->AddString("\nL2CAP Connection successfully established\n");
									//this can happen at 2 places in this code!!!!!!!!!!!!!! the other is up

									
									client->ConnectionLevel = L2CAP_Level_Configured;
								};				
								

								
							};
								
						
						};

						};
					
					}
					catch(char* excpt){logLB->AddString(excpt);return;}

				
					
					break;
			 }
			 
			}


	}

L2CAPServer* L2CAPServer::getInstance(CListBox *lb)
	{
		if(curInstance == NULL)		
			curInstance = new L2CAPServer(lb);
	
		return curInstance;
	}
void L2CAPServer::OnDisconnect(USHORT handle)
	{
	
			  
	
	//tell client connected l2 with "dev","psm","cid"
	}


L2CAPServer::~L2CAPServer(void)
	{
		this->L2CAPClients.RemoveAll();
		this->SourceHCIClients.RemoveAll();
	
	}