#include "stdafx.h"
#include "RFCOMM.h"
#include "stdio.h"



/*		AddressStructPtr address;
		BYTE* control;
		LengthStructPtr length;

		USHORT packetLength;
		BYTE* wholePacket;
		USHORT payLoadLength;
		BYTE* payLoad;
*/
AddressStruct ByteEncoder::MakeAddressStruct(BYTE CR,BYTE D,BYTE Channel)
{
	AddressStruct as;
	as.EA = 1;
	as.CR = CR;
	as.D = D;
	as.ServerChannel = Channel;

	return (as);
};

BYTE ByteEncoder::MakeControlByte(BYTE Control,BYTE PF)
{
	//printf("sdasdasd %02x\n",Control+(PF?SetPF_Factor:0));
	return (Control+(PF?SetPF_Factor:0));

};

USHORT ByteEncoder::MakeLengthBytes(USHORT length) // returns encoded to length in RFCOMM/GSM TS 07.10 spec
// use the returned USHORT to retermine if EA=1 or 0 from the 1st byte (we use big-endain for this),
// if 1 means the length is only 1 byte long, use only the first byte
// if EA =0  means there's 2 bytes of length (we don't support more than this, its max in 2 bytes is already too large)
// use both the bytes
{
	printf("Length byte maker length: %d\n",length);
	BYTE* lp = (BYTE*) &length;

	USHORT ret = 0;
	BYTE* retp  = (BYTE*) &ret;
	if(length<=MaxIn7Bits) //use 1 byte
	{
		retp[0] = lp[0];
		retp[1] = 0;
		retp[0] = retp[0]<<1; //7bits matter 
		retp[0] = retp[0] | 0x01; //EA=1
		printf("case1");

	}
	else // use 2 bytes
	{
		retp[0] = lp[0];
		retp[1] = lp[1];
		ret = ret<<1;//the filled would be 0, so EA =0		
	};

	printf("lbmaker: [0] = %d [1] = %d",lp[0],lp[1]);
	return ret;
};

TypeStruct ByteEncoder::MakeTypeStruct(BYTE CR, BYTE type)
{
	
	TypeStruct ts;
	ts.CR = CR;
	ts.type = type;
	ts.EA = 1;
	return ts;
};

LengthStruct ByteEncoder::MakeSmallLengthStruct(BYTE length)
{
	LengthStruct ls;
	ls.EA=1;
	ls.length = length;
	return ls;
};


InitialCreditStruct ByteEncoder::MakeInitialCreditStruct(BYTE credits)
{
	InitialCreditStruct ic;
	ic.padding = 0;
	ic.K = credits;
	return ic;
};


RFCOMM_Frame::RFCOMM_Frame(AddressStruct addr, BYTE cntrl, BYTE* payLoad,USHORT payLoadLength )
{


	this->payLoadLength = payLoadLength;

	USHORT lb = ByteEncoder::MakeLengthBytes(payLoadLength);
	BYTE* bp = (BYTE*) &lb;

	if(bp[1])
		this->packetLength = this->payLoadLength+RFCOMM_Header_Length+2;//add for FCS and 1 extra byte for length field(EA=0)
	else
		this->packetLength = this->payLoadLength+RFCOMM_Header_Length+1;//add for FCS
	

	
	this->wholePacket = new BYTE[this->packetLength];
	
	
	
	((RFCOMM_FrameStructPtr)this->wholePacket)->Address = addr;
	((RFCOMM_FrameStructPtr)this->wholePacket)->Control = cntrl;
	
	
	((BYTE*) &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length))[0] = bp[0];
	this->payLoad = ((BYTE*) &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length))+1;
	
		if(bp[1])
			{

				((BYTE*) &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length))[1] = bp[1];
				this->payLoad++; //length consists of 2 bytes so the payload must point 1 byte further

			};
	
	this->address = &(((RFCOMM_FrameStructPtr)this->wholePacket)->Address);
	this->control = &(((RFCOMM_FrameStructPtr)this->wholePacket)->Control);
	this->length = &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length);

	printf("RFCOMMFRAME constructor\n");

	printf("payLoadLength = %d\n",payLoadLength);
	for(int i=0; i< payLoadLength;i++)
	{
		printf("%d\n",i);
		if(payLoad && payLoad[i])
		{	printf("%d\n",i);this->payLoad[i] = payLoad[i];}
		else
		{this->payLoad[i] = 0;}
	}
	
	this->allocated = 1;
	
	
	//add FCS 
	this->payLoad[i] = ng_btsocket_rfcomm_fcs3(this->wholePacket);
	
	
};


RFCOMM_Frame::RFCOMM_Frame(BYTE* array, USHORT length)
{
	
	this->wholePacket = array;
	this->packetLength = length;
	this->payLoadLength = length-RFCOMM_Header_Length - 1; //FCS
	
	this->address = (AddressStructPtr) array + RFCOMM_AddressOffset;
	this->control = array+RFCOMM_ControlOffset;
	this->length = (LengthStructPtr) array + RFCOMM_LengthOffset;
	
	if((this->length->EA)==1)
	{(this->payLoad) = ((BYTE*)this->length)+1;}
	else
	{(this->payLoad) = ((BYTE*)this->length)+2;this->payLoadLength--;/*this decrements the real value of payLoadLength, NOT its pointer!*/}

	

	this->allocated=0;
	
};




RFCOMM_Frame::~RFCOMM_Frame()
{
	
	if(allocated)
	{delete[] (this->wholePacket);}
};





Signalling_Frame::Signalling_Frame(BYTE CR,BYTE cntrl, BYTE* payLoad, USHORT payLoadLength) : RFCOMM_Frame(ByteEncoder::MakeAddressStruct(CR,0/*DLCI =0 ; D = 0  for signalling channel*/,RFCOMM_SignallingChannel),cntrl,payLoad,payLoadLength)
{
		
};
Signalling_Frame::Signalling_Frame(BYTE* array,USHORT length) : RFCOMM_Frame(array,length)	
{
	
};










UA_Frame::UA_Frame(AddressStruct addr):RFCOMM_Frame(addr,Control_UA+SetPF_Factor,NULL,0) //PF is set...
{


};

UA_Frame::UA_Frame(BYTE* array,USHORT length):RFCOMM_Frame(array, length)
{

};

SABM_Frame::SABM_Frame(AddressStruct addr):RFCOMM_Frame(addr,Control_SABM+SetPF_Factor,NULL,0)
{

};

SABM_Frame::SABM_Frame(BYTE* array,USHORT length):RFCOMM_Frame(array, length)
{

};

DISC_Frame::DISC_Frame(AddressStruct addr):RFCOMM_Frame(addr,Control_DISC+SetPF_Factor,NULL,0)
{
};

DISC_Frame::DISC_Frame(BYTE* array,USHORT length):RFCOMM_Frame(array, length)
{
};


DM_Frame::DM_Frame(AddressStruct addr):RFCOMM_Frame(addr,Control_DM+SetPF_Factor,NULL,0)
{

};
DM_Frame::DM_Frame(BYTE* array,USHORT length):RFCOMM_Frame(array, length)
{

};






SignallingUIH_Frame::SignallingUIH_Frame(BYTE CR, BYTE* payLoad, USHORT length):Signalling_Frame(CR,Control_UIH/*PF NOT set because this is considered as data*/,NULL,length) // use this to make a UIH Frame with your payload which would be a PN or MSC Message ... etc, 
{
	//UIH Frams use FCS based on Address and Control only: overwrite the genereal FCS set by the RFCOMM_Frame constructor
	this->wholePacket[this->packetLength-1] = ng_btsocket_rfcomm_fcs2(this->wholePacket);
};

SignallingUIH_Frame::SignallingUIH_Frame(BYTE* array, USHORT length):Signalling_Frame(array, length) // use this to decode an incoming UIH frame
{

};









RFCOMM_MultiplexerFrame::RFCOMM_MultiplexerFrame(BYTE CR, TypeStruct Type,LengthStruct Length/*length is in Length*/) : SignallingUIH_Frame(CR,NULL, Length.length+ MultiplexerMessageHeaderLength) 
{
	this->payLoad[MultiplexerTypeOffset] = *((BYTE*) (&Type));
	this->payLoad[MultiplexerLengthOffset] = *((BYTE*) (&Length));
	this->theParams = this->payLoad + MultiplexerMessageParamsOffset;
	
	this->messageTypeStr = (TypeStructPtr) this->payLoad+MultiplexerTypeOffset;
	this->messageLengthStr =  (LengthStructPtr) this->payLoad+MultiplexerLengthOffset;

	this->paramsLength = this->messageLengthStr->length;	
};

RFCOMM_MultiplexerFrame::RFCOMM_MultiplexerFrame(BYTE* array, USHORT length) : SignallingUIH_Frame(array,length)
{
	this->messageTypeStr = (TypeStructPtr) this->payLoad+MultiplexerTypeOffset;
	this->messageLengthStr =  (LengthStructPtr) this->payLoad+MultiplexerLengthOffset;
	this->theParams = this->payLoad + MultiplexerMessageParamsOffset;
	this->paramsLength = this->messageLengthStr->length;	
};


PN_Command_Frame::PN_Command_Frame(BYTE OuterCR, BYTE InnerCR, AddressStruct DLCI, USHORT maxFrameSz, InitialCreditStruct initialCredits):RFCOMM_MultiplexerFrame(OuterCR, ByteEncoder::MakeTypeStruct(InnerCR,Type_PN),ByteEncoder::MakeSmallLengthStruct(PNCommandValuesLength) ) 
{
	
	vals  = (PNCommandValuesStructPtr) this->theParams;
	printf("lllllllllllllllllllll");
	

	//The set to zero commands after this are canceled to comments since the initializer in the RFCOMM_Frame contructor already set undifined values to 0
	
	//BYTE D:1;
	vals->D = DLCI.D;
	//BYTE ServerChannel:5;
	vals->ServerChannel = DLCI.ServerChannel;
	//BYTE padding1:2;//this should be zeros 
	//vals->padding1 = 0;
	

	//BYTE FrameType: 4; (These are "I" bits , as refered to in GSM TS 07.10)
	//vals->FrameType = 0; // For UIH
	//BYTE CL:4; // BT spec: this must be set to 0 
	vals->CL = 0xf; //CL1 to CL4 is set to F for Bluetooth Version 1.1: Request

	//BYTE Priority:6;
	//vals->Priority = 0;
	//BYTE padding2:2;
	//vals->padding2 = 0;

	
	
	//BYTE Timer; //BT spec: this must be 0
	//vals->Timer =0;


	//USHORT MaxFrameSize;
	vals->MaxFrameSize = maxFrameSz;

	//BYTE NA; // Max retransmissions
	//vals->NA = 0;

	//BYTE InitialCredit:3;
	vals->InitialCredit = *((BYTE*) &initialCredits);
	//BYTE padding3:5;
	//vals->padding3 = 0;

	
};

PN_Command_Frame::PN_Command_Frame(BYTE* array, USHORT length) :RFCOMM_MultiplexerFrame(array,length)
{
	vals  = (PNCommandValuesStructPtr) this->theParams;
};

MSC_Command_Frame::MSC_Command_Frame(BYTE OuterCR, BYTE InnerCR, AddressStruct DLCI, BYTE FC, BYTE RTC, BYTE RTR):RFCOMM_MultiplexerFrame(OuterCR, ByteEncoder::MakeTypeStruct(InnerCR,Type_MSC),ByteEncoder::MakeSmallLengthStruct(MSCCommandValuesLength) )
{

	MSCParamsStructPtr vals = (MSCParamsStructPtr) this->theParams;

	
	vals->DLCI.EA=1;
	vals->DLCI.CR=1; //set by GSM spec TS07.10 (ts_101369v060500p.pdf) P. 29
	vals->DLCI.D=DLCI.D;
	vals->DLCI.ServerChannel = DLCI.ServerChannel;
	
	
	
	//BYTE EA:1;
	vals->EA=1;
	
	
	//BYTE FC:1;
	vals->FC = FC;
	//BYTE RTC:1;
	vals->RTC = RTC;
	//BYTE RTR:1;
	vals->RTR = RTR;
	


	//BYTE padded:2;	
	vals->padded = 0;
	//BYTE IC:1;
	vals->IC = 0; //no incoming calls here!
	//BYTE DV:1;
	vals->DV = 1; //yes, we're sending valid data


};
MSC_Command_Frame::MSC_Command_Frame(BYTE* array, USHORT length):RFCOMM_MultiplexerFrame(array,length)
{
	
};






CreditedRFCOMM_Frame::CreditedRFCOMM_Frame(AddressStruct addr, BYTE cntrl, BYTE crd, BYTE* payLoad,USHORT payLoadLength)
{
	/*AddressStructPtr address;
		BYTE* control;
		LengthStructPtr length;
		BYTE* credit;

		USHORT packetLength;
		BYTE* wholePacket;
		USHORT payLoadLength;
		BYTE* payLoad;*/

	this->payLoadLength = payLoadLength;

	USHORT lb = ByteEncoder::MakeLengthBytes(payLoadLength);
	BYTE* bp = (BYTE*) &lb;

	if(bp[1])
		this->packetLength = this->payLoadLength+RFCOMM_Header_Length+3;//add for FCS and credit byte and 1 extra byte for length field(EA=0)
	else
		this->packetLength = this->payLoadLength+RFCOMM_Header_Length+2;//add for FCS and credit byte
	
	this->wholePacket = new BYTE[this->packetLength];
	
	
	
	((RFCOMM_FrameStructPtr)this->wholePacket)->Address = addr;
	((RFCOMM_FrameStructPtr)this->wholePacket)->Control = cntrl;
	

	
		((BYTE*) &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length))[0] = bp[0];
		
		this->credit = ((BYTE*) &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length))+1;
		if(bp[1])
			{

				((BYTE*) &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length))[1] = bp[1];
				this->credit++; //length consists of 2 bytes so the payload must point 1 byte further

			};
	
		*(this->credit) = crd;
		this->payLoad = this->credit+1;



	this->address = &(((RFCOMM_FrameStructPtr)this->wholePacket)->Address);
	this->control = &(((RFCOMM_FrameStructPtr)this->wholePacket)->Control);
	this->length = &(((RFCOMM_FrameStructPtr)this->wholePacket)->Length);

	printf("RFCOMMFRAME constructor\n");

	printf("payLoadLength = %d\n",payLoadLength);
	for(int i=0; i< payLoadLength;i++)
	{
		printf("%d\n",i);
		if(payLoad && payLoad[i])
		{printf("NOT    NULL");printf("%d\n",i);this->payLoad[i] = payLoad[i];}
		else
		{printf("NULL");this->payLoad[i] = 0;}
	}
	
	this->allocated = 1;
	
	
	//add FCS 
	this->payLoad[i] = ng_btsocket_rfcomm_fcs3(this->wholePacket);
};

CreditedRFCOMM_Frame::CreditedRFCOMM_Frame(BYTE* array, USHORT length)
{
	this->wholePacket = array;
	this->packetLength = length;
	this->payLoadLength = length-RFCOMM_Header_Length - 2; //FCS and credit byte
	
	this->address = (AddressStructPtr) array + RFCOMM_AddressOffset;
	this->control = array+RFCOMM_ControlOffset;
	this->length = (LengthStructPtr) array + RFCOMM_LengthOffset;
	
	
	
	if((this->length->EA)==1)
	{(this->credit) = ((BYTE*)this->length)+1;}
	else
	{(this->credit) = ((BYTE*)this->length)+2;this->payLoadLength--;/*this decrements the real value of payLoadLength, NOT its pointer!*/}

	this->payLoad = this->credit+1;


	this->allocated=0;
};
CreditedRFCOMM_Frame::~CreditedRFCOMM_Frame()
{
	
	if(allocated)
	{delete[] (this->wholePacket);}
};


CreditedDataUIH_Frame::CreditedDataUIH_Frame(AddressStruct addr , BYTE credits, BYTE* payLoad, USHORT length) : CreditedRFCOMM_Frame(addr, Control_UIH+SetPF_Factor,credits,payLoad, length)
{
	this->wholePacket[this->packetLength-1] = ng_btsocket_rfcomm_fcs2(this->wholePacket);
};

CreditedDataUIH_Frame::CreditedDataUIH_Frame(BYTE* array, USHORT length) :CreditedRFCOMM_Frame( array, length)
{

};

NoCreditDataUIH_Frame::NoCreditDataUIH_Frame(AddressStruct addr , BYTE* payLoad, USHORT length) : RFCOMM_Frame(addr, Control_UIH,payLoad, length)
{
	this->wholePacket[this->packetLength-1] = ng_btsocket_rfcomm_fcs2(this->wholePacket);
};

NoCreditDataUIH_Frame::NoCreditDataUIH_Frame(BYTE* array, USHORT length) :RFCOMM_Frame( array, length)
{

};

	



