#include "StdAfx.h"
#include "SDP.h"

#include "Conversions.h"




//SDP_PDU function definitions
SDP_PDU::SDP_PDU(BYTE pduID,BEUS* transactionID,BEUS* parameterLength, BYTE ContinuationState)//for outgoing
    {
        this->wholePDU = new BYTE[parameterLength->getValUSHORT()+SDP_PDUHeaderLength];
        this->wholePDULength = parameterLength->getValUSHORT()+SDP_PDUHeaderLength;
        this->allocatedOwnPDU =1; //set flag for deletion of wholePDU buffer in the destructor
        ((SDP_PDUHeaderStruct)(this->wholePDU))->pduID = pduID;
        
//        Converter::swapUSHORT(&transactionID); // don't worry! we're converting only the parameter: the parameter is just a copy of the real one...        
        transactionID->copyValTo((BYTE*)(((SDP_PDUHeaderStruct)(this->wholePDU))->BEUStransactionID));

  //      Converter::swapUSHORT(&parameterLength);
        parameterLength->copyValTo((BYTE*)(((SDP_PDUHeaderStruct)(this->wholePDU))->BEUSparameterLength));        

        delete transactionID;
        delete parameterLength;

        this->wholePDU[(this->wholePDULength)-1/*the last byte*/] = ContinuationState;
        this->theParameters = this->wholePDU + SDP_PDUHeaderLength;
    };

SDP_PDU::SDP_PDU(BYTE* bp, USHORT length) //for incoming
    {
        this->allocatedOwnPDU =0; //set flag to NOT delete wholePDU buffer in the destructor
        this->wholePDU = bp;
        this->wholePDULength = length;
        this->theParameters = this->wholePDU + SDP_PDUHeaderLength;
    };

BYTE SDP_PDU::getPDUID()
    {
       
        return ((SDP_PDUHeaderStruct)(this->wholePDU))->pduID;
    };
BEUS* SDP_PDU::getTransactionIDBEUS()
    {
        BEUS *ret = new BEUS( ((SDP_PDUHeaderStruct)(this->wholePDU))->BEUStransactionID );
        return ret;
    };
BEUS* SDP_PDU::getParameterLengthBEUS()
    {
        
        BEUS *ret = new BEUS( ((SDP_PDUHeaderStruct)(this->wholePDU))->BEUSparameterLength);
        return ret;
    };
BYTE SDP_PDU::getContinuationState()
    {
        return (this->wholePDU[(this->wholePDULength)-1/*the last byte*/]);
    };









//SDP_ServiceSearchRequestPDU fucntion definitions
SDP_ServiceSearchRequestPDU::SDP_ServiceSearchRequestPDU(BEUS* transactionID,DataElement* ServiceSearchPattern/*this is a DataElementSequence, must be already converted to Big-Endian*/,BEUS* MaximumServiceRecordCount,BYTE ContinuationState)   :   SDP_PDU(SDP_ServiceSearchRequestPDUID,transactionID, new BEUS(ServiceSearchPattern->wholeSize+sizeof(USHORT)+sizeof(BYTE)),ContinuationState)
    {


        
        //if ssp->length is less than DEHeaderLength+sizeof(USHORT) then throw an exception

        SDP_DataElementHeaderStruct dehs = ServiceSearchPattern->theDataElement; //this is a pointer!
        
        for(int i=0;i<ServiceSearchPattern->wholeSize;i++)
            this->theParameters[i] = ((BYTE*)ServiceSearchPattern->theDataElement)[i];
        
        MaximumServiceRecordCount->copyValTo((this->theParameters)+i); //pointer arithmetic
        i+=2;
        
        delete ServiceSearchPattern;
        delete MaximumServiceRecordCount;



    };
SDP_ServiceSearchRequestPDU::SDP_ServiceSearchRequestPDU(BYTE* bp, USHORT length) : SDP_PDU(bp,length)
    {
         
    };
BYTE* SDP_ServiceSearchRequestPDU::getSearchUUID(BYTE* nativeRetSize)
    {
        //void* ret;
        //BYTE retType;
        UWORD retSize;
        BYTE *extracted;
        
        SDP_DataElementHeaderStruct des = (SDP_DataElementHeaderStruct) this->theParameters;
            
         //(SDP_DataElementHeaderStruct de/*this is a pointer!*/, BYTE* retType, UWORD* retSize)    
        
        extracted = NULL;
        
        if( des->type == SDP_DataElementType_DataElementSequence)
            {   
            //printf("\n\n\n%02x\n",extracted[0]);

            extracted = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct) des,&retSize);            
            
            printf("\n\n\n%02x\n",extracted[0]);

                if(((SDP_DataElementHeaderStruct)extracted)->type == SDP_DataElementType_UUID)
                    {
                        

                        BYTE* ret = DataElement::ExtractDataElement((SDP_DataElementHeaderStruct) extracted,&retSize);            
                        
                        printf("\nin\n");
                        *nativeRetSize = retSize;
                        return ret;
                    };
            };
        *nativeRetSize = 0;
        return NULL;

    };

BEUS* SDP_ServiceSearchRequestPDU::getMaximumServiceRecordCountBEUS()
    {
        UWORD retSize;
        BYTE* bp =NULL;        
        BEUS* ret;

        SDP_DataElementHeaderStruct des = (SDP_DataElementHeaderStruct) this->theParameters;
        
        
        if(bp = DataElement::ExtractDataElement(des,&retSize ))
                bp += retSize; //pointer arithmetic
        
        ret = new BEUS(bp);

        
        return ret;       

    };

/*BYTE SDP_ServiceSearchRequestPDU::getContinuationState()
    {
    
        UWORD retSize;
        BYTE* bp =NULL;


        SDP_DataElementHeaderStruct des = (SDP_DataElementHeaderStruct) this->theParameters;
        
        
        if(bp = DataElement::ExtractDataElement(des,&retSize ) )
                bp += retSize+sizeof(USHORT);
        //else throw exception
                  
        

  //      Converter::swapUSHORT(&ret);
        return *bp;       

    };
*/

SDP_ServiceSearchResponsePDU::SDP_ServiceSearchResponsePDU(BEUS* transactionID,BEUS* TotalServiceRecordCount, BEUS* CurrentServiceRecordCount, BYTE* ServiceRecordHandleList /*should be already converted to Big-Endian*/,USHORT length, BYTE ContinuationState) :   SDP_PDU(SDP_ServiceSearchResponsePDUID,transactionID,new BEUS(length+2*sizeof(USHORT)+sizeof(BYTE)),ContinuationState)
    {
         
        //if ssp->length is less than DEHeaderLength+sizeof(USHORT) then throw an exception
//        SDP_DataElementHeaderStruct dehs = (SDP_DataElementHeaderStruct)  ServiceSearchPattern->array; //this is a pointer!
        
        SDP_ServiceSearchResponseStruct ssr = (SDP_ServiceSearchResponseStruct) this->theParameters;

        TotalServiceRecordCount->copyValTo(ssr->BEUSTotalServiceRecordCount);

        delete TotalServiceRecordCount;

        CurrentServiceRecordCount->copyValTo(ssr->BEUSCurrentServiceRecordCount);

        delete CurrentServiceRecordCount;
        

        //(ssr->ServiceRecordHandleList)[0] = 0xff;
        for(int i =0; i< length; i++)
          ssr->ServiceRecordHandleList[i] = ServiceRecordHandleList[i];

        




        

        
         
    };

SDP_ServiceSearchResponsePDU::SDP_ServiceSearchResponsePDU(BYTE* bp, USHORT length) : SDP_PDU(bp,length)
    {
        //the parent's constructor would be called before this anyway
        
    };

BEUS* SDP_ServiceSearchResponsePDU::getTotalServiceRecordCountBEUS()
    {
        

        BEUS* ret = NULL;
        ret = new BEUS(((SDP_ServiceSearchResponseStruct) this->theParameters)->BEUSTotalServiceRecordCount);

        

        return (ret);
    };

BEUS* SDP_ServiceSearchResponsePDU::getCurrentServiceRecordCountBEUS()
    {
        BEUS* ret = NULL;
        ret = new BEUS(((SDP_ServiceSearchResponseStruct) this->theParameters)->BEUSCurrentServiceRecordCount);

        return (ret);
    
    };

BYTE* SDP_ServiceSearchResponsePDU::getServiceRecordHandleList(USHORT* retSize) //List of 32 bit handles (ie., coimg one after another)
    {
        
        BYTE* ret = NULL;

        ret = &(((SDP_ServiceSearchResponseStruct) this->theParameters)->ServiceRecordHandleList[0]);
        *retSize = this->wholePDULength -SDP_PDUHeaderLength -1/*continuation*/-4/*curServices and toatalServices*/;

        return (ret);
    };
    

        

SDP_ServiceAttributeRequestPDU::SDP_ServiceAttributeRequestPDU(BEUS* transactionID,BEUW* ServiceRecordHandle, BEUS* MaximumAttributeByteCount,DataElement* AttributeIDList, BYTE ContinuationState)         :SDP_PDU(SDP_ServiceAttributeRequestPDUID,transactionID, new BEUS(AttributeIDList->wholeSize+sizeof(UWORD)+sizeof(USHORT)+sizeof(BYTE)),ContinuationState)
    {
            
            
           ServiceRecordHandle->copyValTo(((SDP_ServiceAttributeRequestStruct) this->theParameters)->ServiceRecordHandle);
           delete ServiceRecordHandle;
           MaximumAttributeByteCount->copyValTo(((SDP_ServiceAttributeRequestStruct) this->theParameters)->MaximumAttributeByteCount);
           delete MaximumAttributeByteCount;
            
           for(int i=0; i< AttributeIDList->wholeSize;i++)
                (((SDP_ServiceAttributeRequestStruct) this->theParameters)->AttributeIDList)[i] = ((BYTE*)(AttributeIDList->theDataElement))[i];

           delete AttributeIDList;

    };
SDP_ServiceAttributeRequestPDU::SDP_ServiceAttributeRequestPDU(BYTE* bp, USHORT length) : SDP_PDU(bp,length)
    {
         //nothing to do
    };
BEUW*   SDP_ServiceAttributeRequestPDU::getServiceRecordHandle()
    {
        return (new BEUW(((SDP_ServiceAttributeRequestStruct) this->theParameters)->ServiceRecordHandle));
    };
BEUS*   SDP_ServiceAttributeRequestPDU::getMaximumAttributeByteCount()
    {
        return (new BEUS(((SDP_ServiceAttributeRequestStruct) this->theParameters)->MaximumAttributeByteCount));
    };
DataElement*    SDP_ServiceAttributeRequestPDU::getAttributeIDList()
    {
        return new DataElement(((SDP_ServiceAttributeRequestStruct)this->theParameters)->AttributeIDList, this->wholePDULength - SDP_PDUHeaderLength - sizeof(USHORT) -sizeof(UWORD) - 1 /*don't include the continuation state*/);

    };



SDP_ServiceAttributeResponsePDU::SDP_ServiceAttributeResponsePDU(BEUS* transactionID, BEUS* AttributeListByteCount, DataElement* AttributeList, BYTE ContinuationState)      :SDP_PDU(SDP_ServiceAttributeResponsePDUID,transactionID, new BEUS(AttributeList->wholeSize+sizeof(USHORT)+sizeof(BYTE)),ContinuationState)
    {
        
            
            
            AttributeListByteCount->copyValTo(((SDP_ServiceAttributeResponseStruct)this->theParameters)->AttributeListByteCount);
            
            delete AttributeListByteCount;
            
            for(int i=0; i< AttributeList->wholeSize;i++)
                (((SDP_ServiceAttributeResponseStruct) this->theParameters)->AttributeList)[i] = ((BYTE*)(AttributeList->theDataElement))[i];

            delete AttributeList;


         
    };
SDP_ServiceAttributeResponsePDU::SDP_ServiceAttributeResponsePDU(BYTE* bp, USHORT length) : SDP_PDU(bp,length)
    {
         //nothing to do
    };
BEUS* SDP_ServiceAttributeResponsePDU::getAttributeListByteCount()
    {
        return new BEUS(((SDP_ServiceAttributeResponseStruct)this->theParameters)->AttributeListByteCount);

    };
DataElement*    SDP_ServiceAttributeResponsePDU::getAttributeList()
    {
        return new DataElement( (((SDP_ServiceAttributeResponseStruct)this->theParameters)->AttributeList), this->wholePDULength -SDP_PDUHeaderLength -sizeof(USHORT) -1/*continuation state is not in the DE*/ );
    };

   
        