#ifndef _DATAELEMENT_H
#define _DATAELEMENT_H

//#include "ByteArray.h"
#include "SDPStructs.h"
#include "Conversions.h"
#ifndef USHORT 
#define USHORT unsigned short
#endif

#ifndef UWORD
#define UWORD unsigned int
#endif

#ifndef BYTE
#define BYTE unsigned char
#endif

#define SDP_DataElementHeaderLength 1

#define SDP_DataElementType_Nil    0
#define SDP_DataElementType_UInt   1
#define SDP_DataElementType_STwosComplementInt 2
#define SDP_DataElementType_UUID   3
#define SDP_DataElementType_TextString     4
#define SDP_DataElementType_Boolean    5
#define SDP_DataElementType_DataElementSequence    6
#define SDP_DataElementType_DataElementAlternative 7
#define SDP_DataElementType_URL    8



typedef struct
{
	BYTE UUID[2];
	BYTE* val; // the UUID's relevant parameters (e.g., Server Channel for RFCOMM)
	BYTE valLength;
} UUID_ValParam; 


class DataElement
    {
    public:
        USHORT wholeSize; // USHORT is used here beacause this wouldn't be exported...
        DataElement(BYTE type, BYTE* payLoad, USHORT length);
        DataElement(BYTE* element, USHORT length);
        ~DataElement(){if(allocatedDE)delete[] ((BYTE*)(this->theDataElement));}
        BYTE *ExtractDataElement(UWORD* retSize);

        
		
		static BYTE* ExtractDataElement(SDP_DataElementHeaderStruct theDataElement/*this is a pointer!!!*/,UWORD* retSize);       
		static UUID_ValParam* ExtractDataElementForUUID(SDP_DataElementHeaderStruct de, USHORT* nParams);//extract and show dataelement sequences
		static BYTE ExtractForRFCOMMChannel(SDP_DataElementHeaderStruct de);



   
        SDP_DataElementHeaderStruct theDataElement;
        
        protected:
            BYTE allocatedDE;
            //DataElement(BYTE type, int size);
            //DataElement(){};
            //BYTE dataInitialized;
            
    };


    
/*class DataElementSequence : DataElement
    {
        
    public:
        DataElementSequence();
        append(DataElement* de);
        
    };*/

#endif