// HCIClient.h: interface for the HCIClient class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HCICLIENT_H__49CD7663_0391_475B_976C_6F1EE7EA6804__INCLUDED_)
#define AFX_HCICLIENT_H__49CD7663_0391_475B_976C_6F1EE7EA6804__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "fbtHciSizes.h"
#include "TidyVector.h"
#include "HCIClientCaller.h"
//typedef void (INPUTHANDLER)(USHORT,BYTE*,USHORT); //HCIConnectionHandle, buff, length

/*
	YOU MUST IMPLEMENT THESE FUNCTIONS (VIA INHERITING) BEFORE USE!!!:

	virtual ~HCIClient();
	virtual HandleInput(USHORT Handle, BYTE* payLoad, USHORT length);	
	virtual HandleInquiryComplete(CListBox* lb);		
	//virtual GetDeviceNameComplete(); ADD IN FUTURE	
	//virtual GetDevicesNamesComplete(); ADD IN FUTURE

	*/
typedef struct _BTDevice
{
	BYTE	BD_ADDR[FBT_HCI_BDADDR_SIZE];
	BYTE	PageScanRepetitionMode;
	BYTE	PageScanPeriodMode;
	BYTE	PageScanMode;
	BYTE	ClassOfDevice[FBT_HCI_DEVICE_CLASS_SIZE];
	USHORT	ClockOffset;
	BYTE	Name[FBT_HCI_NAME_SIZE];
	//USHORT	ConnectionHandle; //One device might have more than 1 handle... and this is is a connection's property, NOT a device's property

} BTDevice, *PBTDevice;

class HCIClient  
{

	//ONE HCI CLIENT PER ONE HCI CONNECTION. (or you may just use it for inquiries... without making a connection)
	//SET THE TARGET DEVICE BY bool SetTargetDevice(BTDevice dev);, this can be done only when a connection is not in place...
	//Connect() would connect to the target device...

public:
	
	////////////////////////////////////////////////////
	//called by HCIServer 
	~HCIClient();
	virtual void HandleInput(USHORT Handle, BYTE* payLoad, USHORT length);	
	virtual void HandleInquiryComplete();	//devices would be in the InquiredDevices array
	//virtual void HandleInquiryResult();
	
	//virtual GetDeviceNameComplete(); ADD IN FUTURE	
	//virtual GetDevicesNamesComplete(); ADD IN FUTURE
	void OnDisconnect(); 
	BOOL					AddressToString(BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE], CString &szAddress);
	////////////////////////////////////////////////////
	//called by HCIServer 
	
	//User functions
	HCIClient(HCIClientCaller* caller,CListBox* lb);
	
	bool Connect(BTDevice dev);		//modifies Handle if successful
	bool Disconnect();
	bool DoInquiry(); //result would be in the InquiredDevices vector
	bool SendHCIPayload(BYTE* payLoad, USHORT length);
	
	//bool GetDeviceName(BTDevice); ADD IN FUTURE
	
	

	void*      Server; //HCIServer ptr address
	TidyVector  *InquiredDevices;	// from inquiry, this will be cleared everytime an inquiry is done
	BTDevice	Device;	//set by SetTargetDevice
	USHORT		Handle;	
	bool	connected;// can be modified by connect() and disconnect and OnDisconnect(by remote device)
	HCIClientCaller* caller;
	
};


#endif // !defined(AFX_HCICLIENT_H__49CD7663_0391_475B_976C_6F1EE7EA6804__INCLUDED_)
