// HCIServer.h: interface for the HCIServer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HCISERVER_H__F5CEBC9D_B266_42B5_8E5D_314E6314ECE8__INCLUDED_)
#define AFX_HCISERVER_H__F5CEBC9D_B266_42B5_8E5D_314E6314ECE8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000




//#include "stdafx.h"
#include "fbtHciRoundTrip.h"
#include "RoutinedVector.h"
#include "HCIClient.h"
#include "se_translator.h"

#include <afxcoll.h>


#define HCIDataPacketHeaderSize	4
//typedef (printLogger) void CALLBACK (char *);

//typedef void (INQUIRYCOMPLETEHANDLER)(void*, int); //the client's function to call to notify 
typedef struct   _HCI_Read_Buffer_SizeReturnStruct
	{	 
		 BYTE	status;
		 USHORT ACL_DataPayloadLength;
		 BYTE	SCO_DataPayloadLength;
		 USHORT MaxACLDataPacketsInBuff;
		 USHORT MaxSCODataPacketsInBuff;

	}HCI_Read_Buffer_SizeReturnStruct,*PHCI_Read_Buffer_SizeReturnStruct;


class HCIServer  : public CHciRoundTrip
{

public:

	
	static HCIServer* getInstance(CListBox *LogLB);
	
	
	
	
	static bool Shutdown();
	virtual ~HCIServer();	
	bool DoInquiry(HCIClient* inquiryClient); //returns false if device is busy (already doing this same procedure) ....
	bool GetNames(HCIClient* getNamesClient); //returns false if device is busy (already doing this same procedure) ....

	bool ConnectACL(HCIClient* connectClient); //Handle will be stored in the Device's object in the Devices' Array
	//BTDevice is used in the connect command so that you can use devices that come from a saved BTDevice, not only freshly inquired devices as would be in using only the BDAddr since BDAddr would be used to get other vals in the Devices inquired array essential for making a connection
	bool Disconnect(HCIClient* disconnectClient);
    bool SendHCIPayload(HCIClient* sendClient,BYTE* bptr, USHORT length); //called by in-door HCI Clients, does fragmentation according to Max_ACLPacketSize
	void DistributeDataPacket(PFBT_HCI_DATA_PACKET pData); //called by reader, does re-assembly of fragments,send to in-door HCI Clients (callback its handler function)
	DWORD OnDisconnectionComplete(BYTE Status, USHORT ConnectionHandle, BYTE Reason);
	DWORD OnPINCodeRequest(BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE]);
	CListBox *LogLB;
	
	
	CPtrArray   *HCIClients; // must have a device in *Devices down, TidyVector not used becuase we do not own the HCIClients, we can't delete them when we remove it from the array as in TidyVector		
	USHORT getMaxACLDataPayLoadLength();

protected:
	static HCIServer* curInstance;
	HCIServer(CListBox *LogLB/*,CListBox *DevicesLB*/ );
	BYTE			pBuffer[1024]; //add buffers to each HCIClient in future to allow multi-using of the input buffers, especially when there's fragmented HCI input coming (do re-assembly for input the future (TODO))
	DWORD			dwBytesRead;
	USHORT Max_ACLDataPayLoad ;
	BYTE Max_SCODataPayLoad  ;
	USHORT MAXACLPacketsInBuff ;
	USHORT MAXSCOPacketsInBuff ;
	
	RoutinedVector* outbox;

	//bool DeviceNotFound(PBTDevice dev);	
	bool BD_Addr_Equal(BYTE BD_ADDR1[FBT_HCI_BDADDR_SIZE],BYTE BD_ADDR2[FBT_HCI_BDADDR_SIZE]);

	//HCIClients ptr to clients that are waiting for a response of a lenghty operation ( used to notify... )
	//set to NULL when not in use... if not null means in use...
	HCIClient* inquiryClient; 
	//HCIClient* getNamesClient;
	//HCIClient* isConnectedClient;

	//INQUIRYCOMPLETEHANDLER *iqh;
	//PBTDevice GetDevicePtr(BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE]); //similar to getDeviceInfo but this returns a pointer to the real object
	
	///// Delarations FROM FREEBT /////////////////////////////////////////////////////////////////
	FBT_HCI_READ_LOCAL_VERSION_INFORMATION_COMPLETE CommandComplete;
	BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE];

	DWORD OnInquiryComplete(BYTE Status, BYTE NumResponses);
	DWORD OnInquiryResult(BYTE NumResponses, BYTE BD_ADDR[FBT_HCI_VARIABLE_SIZE][FBT_HCI_BDADDR_SIZE], BYTE PageScanRepetitionMode[FBT_HCI_VARIABLE_SIZE], BYTE PageScanPeriodMode[FBT_HCI_VARIABLE_SIZE], BYTE PageScanMode[FBT_HCI_VARIABLE_SIZE], BYTE ClassOfDevice[FBT_HCI_VARIABLE_SIZE][FBT_HCI_DEVICE_CLASS_SIZE], USHORT ClockOffset[FBT_HCI_VARIABLE_SIZE]);
	
	//DWORD OnConnectionRequest(BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE], ULONG ClassOfDevice[FBT_HCI_DEVICE_CLASS_SIZE], BYTE LinkType);//called by supers
	//DWORD OnConnectionComplete(BYTE nStatus, USHORT nConnectionHandle, BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE], BYTE nLinkType, BYTE nEncryptionMode);////called by supers
	
	DWORD SendHciCommand(PFBT_HCI_CMD_HEADER lpCommand, DWORD dwBufferSize);	
	DWORD OnEvent(PFBT_HCI_EVENT_HEADER pEvent, DWORD Length);	
	BOOL					InitBT(void);
	static DWORD CALLBACK	Reader(LPVOID lpParameter);
	//int						FindDeviceByAddress(BYTE BD_ADDR[FBT_HCI_BDADDR_SIZE]);
	//int						FindDeviceByConnectionHandle(USHORT nConnectionHandle);
	
	LRESULT OnInitialise(WPARAM wParam, LPARAM lParam);
	se_translator translator;
	/////////////////////////////////////////////////////////////////	

};

#endif // !defined(AFX_HCISERVER_H__F5CEBC9D_B266_42B5_8E5D_314E6314ECE8__INCLUDED_)
