#pragma once

#include "HCIClient.h"

#include "L2CAPConnection.h"
#include "L2CAPClientCaller.h"

/*#define L2CAP_Level_Start 0
//send ConReq
#define L2CAP_Level_WaitingForConResp 1
//send ConfReq
#define L2CAP_Level_Configuring 2

#define L2CAP_Level_Configured 3
  */

class L2CAPClient 
	{
	public:
		
		L2CAPClient(L2CAPClientCaller* caller, CListBox* lb);
		bool connect(BTDevice dev,BYTE PSM);
		bool disconnect(bool disconnectHCI);		
		bool SendL2CAPPacket(L2CAP_Packet* pkt);
		bool SendL2CAPPayload(BYTE* payLoad, USHORT length);

		
		void OnL2CAPDataInput(L2CAPClient* client, BYTE* payLoad, USHORT length);
		
		void OnDisconnected();		
		
		~L2CAPClient(void);	
		L2CAPClientCaller* caller;
		DWORD l2server;
		CListBox *logLB;
		HCIClient *HCI_Client;
		int ConnectionLevel;
		USHORT PSM;
		USHORT ourCID;
		USHORT theirCID;
		USHORT ourMTU;
		USHORT theirMTU;		
		int  theirConfigureLevel;//=0;
		int  ourConfigureLevel;//=0;
		BYTE ourCommandIdentifier;//=1;
		BYTE theirCommandIdentifier;//=1;	


		void renewOurCommandIdentifier(); //contact server
		void getNewCID(); ////contact server

		

	};
