/*

L2CAPConnection.h 
By Kasidit Yusuf

Using the Bluetooth 1.1 specification.

Copyright (c) 2004 Kasidit Yusuf. All Rights Reserved.

*/

#ifndef _L2CAPCONNECTION_H
#define _L2CAPCONNECTION_H
#include "malloc.h"
#include "L2CAPStructs.h"
#include "ByteArray.h"

#define L2CAP_CommandRejectCommandCode	0x01
#define L2CAP_ConnectionRequestCommandCode	0x02 
#define L2CAP_ConnectionResponseCommandCode	0x03
#define L2CAP_ConfigureRequestCommandCode	0x04 
#define L2CAP_ConfigureResponseCommandCode	0x05 
#define L2CAP_DisconnectRequestCommandCode	0x06 
#define L2CAP_DisconnectResponseCommandCode	0x07 
#define L2CAP_EchoRequestCommandCode	0x08 
#define L2CAP_EchoResponseCommandCode	0x09 
#define L2CAP_InformationRequestCommandCode	0x0A 
#define L2CAP_InformationResponseCommandCode	0x0B 



#define L2CAP_SignallingCID 0x0001

#define L2CAP_DefaultMTU	672 /*672 bytes default MTU P.298 in BT1.1 pdf doc*/
//L2CAP Packets
#define L2CAP_PacketHeaderLength 4

//#define L2CAP_PacketLengthOffset 0
//#define L2CAP_PacketCIDOffset 2
//#define L2CAP_PacketCommand1Offset 4

//L2CAP Commands
//#define L2CAP_CommandCodeOffset 0
//#define L2CAP_CommandIdentifierOffset 1
//#define L2CAP_CommandParameterLengthOffset 2

#define L2CAP_CommandHeaderLength 4



//Connection Request
#define L2CAP_ConnectionRequestCommandParametersLength  4
#define L2CAP_DisconnectRequestCommandParametersLength  4
#define L2CAP_DisconnectResponseCommandParametersLength 4

//#define L2CAP_ConnectionRequestPSMOffset 4
//#define L2CAP_ConnectionRequestSrcCIDOffset 6

//#define L2CAP_ConnectionRequestCommandPacketLength 8

#define L2CAP_PSM_SDP 0x0001
#define L2CAP_PSM_RFCOMM 0x0003
#define L2CAP_PSM_TELEPHONYCONTROLPROTOCOL 0x0005

//Connection Response

#define L2CAP_ConnectionResponseCommandParametersLength 8

//#define L2CAP_ConnectionResponseDestCIDOffset 4
//#define L2CAP_ConnectionResponseSrcCIDOffset 6
//#define L2CAP_ConnectionResponseResultOffset 8
//#define L2CAP_ConnectionResponseStatusOffset 10

//#define L2CAP_ConnectionResponseCommandPacketLength 12

#define L2CAP_ConnectionResponseCommand_Result_Success 0x0000
#define L2CAP_ConnectionResponseCommand_Result_Pending 0x0001
#define L2CAP_ConnectionResponseCommand_Result_RefusedPSMNotSupported 0x0002
#define L2CAP_ConnectionResponseCommand_Result_RefusedSecurityBlock 0x0003
#define L2CAP_ConnectionResponseCommand_Result_RefusedOutOfResources 0x0004

#define L2CAP_ConnectionResponseCommand_Status_NoFurtherInfoAvailable 0x0000
#define L2CAP_ConnectionResponseCommand_Stauts_AuthenticationPending 0x0001
#define L2CAP_ConnectionResponseCommand_Status_AuthorizationPending 0x0002


#define L2CAP_MinConfigureRequestCommandParametersLength 4
#define L2CAP_MinConfigureResponseCommandParametersLength 6

#define L2CAP_MTUConfigureOptionTypeCode 1
#define L2CAP_MTUConfigureOptionParameterLength 2
#define L2CAP_FlushTimeoutConfigureOptionTypeCode 2
#define L2CAP_FlushTimeoutConfigureOptionParameterLength 2

#define L2CAP_MinCommandRejectCommandParametersLength 2








class L2CAP_Packet
{
public:
	
	L2CAP_Packet(USHORT CID, int payLoadLength); //used by inherited classes to create L2CAPCommands for sending out. Only the classes at the end will do the memory allocation,not here;
    L2CAP_Packet(USHORT CID, BYTE* payLoad, int payLoadLength);//used for encapsulating payloads of higher layers
	L2CAP_Packet(ByteArray *wholePacket/*the pointer points to the start of the WHOLE L2CAP Packet*/); //used to decode incoming commands. Must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems
	L2CAP_Packet(){allocatedOwnPacket = 0;};
	
	
	L2CAP_PacketStruct theL2CAPPacket; //this is a pointer!!!
	int packetLength; // this is the array's length
    int dataLength;
    BYTE allocatedOwnPacket;
	//unsigned char data[1];	
    ~L2CAP_Packet(){if(allocatedOwnPacket)delete[] ((BYTE*) theL2CAPPacket);};

};


class L2CAP_CommandPacket : public L2CAP_Packet
{
public:
	L2CAP_CommandPacket(BYTE code, BYTE identifier,int parametersLength);
	L2CAP_CommandPacket(ByteArray* wholePacket);
	L2CAP_CommandPacket();
	L2CAP_CommandStruct theL2CAPCommand;

	
	
};










class L2CAP_CommandRejectCommandPacket : public L2CAP_CommandPacket
{

public:
	L2CAP_CommandRejectCommandPacket(USHORT reason,USHORT data/*set to 0 if none*/);//used for outgoing packets
	L2CAP_CommandRejectCommandPacket(ByteArray *wholePacket); //used for incoming packets.... //must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems

	L2CAP_CommandRejectCommandParametersStruct theParameters;
	

	
};

class L2CAP_DisconnectRequestCommandPacket : public L2CAP_CommandPacket
{

public:
	L2CAP_DisconnectRequestCommandPacket(BYTE identifier,USHORT destCID,USHORT srcCID);
	L2CAP_DisconnectRequestCommandPacket(ByteArray *wholePacket); //used for incoming packets.... //must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems

	L2CAP_DisconnectRequestCommandParametersStruct theParameters;
	

	
		
	
};
class L2CAP_DisconnectResponseCommandPacket : public L2CAP_CommandPacket
{

public:
	L2CAP_DisconnectResponseCommandPacket(BYTE identifier,USHORT destCID,USHORT srcCID);
	L2CAP_DisconnectResponseCommandPacket(ByteArray *wholePacket); //used for incoming packets.... //must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems

	L2CAP_DisconnectResponseCommandParametersStruct theParameters;
	

		
};


class L2CAP_ConnectionRequestCommandPacket : public L2CAP_CommandPacket
{

public:
	L2CAP_ConnectionRequestCommandPacket(BYTE identifier, USHORT PSM,USHORT srcCID);//used for outgoing packets
	L2CAP_ConnectionRequestCommandPacket(ByteArray *wholePacket); //used for incoming packets.... //must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems
	L2CAP_ConnectionRequestCommandParametersStruct theParameters;
	

};



class L2CAP_ConnectionResponseCommandPacket : public L2CAP_CommandPacket
{

public:
	L2CAP_ConnectionResponseCommandPacket(BYTE identifier, USHORT destCID,USHORT srcCID,USHORT result, USHORT status);//used for outgoing packets
    L2CAP_ConnectionResponseCommandPacket(ByteArray *wholePacket); //used for incoming packets.... //must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems
	L2CAP_ConnectionResponseCommandParametersStruct theParameters;
	

};


class L2CAP_ConfigureRequestCommandPacket : public L2CAP_CommandPacket
{

public:
	L2CAP_ConfigureRequestCommandPacket(BYTE identifier, USHORT destCID,USHORT flags,ByteArray* options/*input NULL if no options*/);//used for outgoing packets
    L2CAP_ConfigureRequestCommandPacket(ByteArray *wholePacket); //used for incoming packets.... //must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems
	
	L2CAP_ConfigureRequestCommandParametersStruct theParameters;
	

};


class L2CAP_ConfigureResponseCommandPacket : public L2CAP_CommandPacket
{

public:
	L2CAP_ConfigureResponseCommandPacket(BYTE identifier, USHORT srcCID,USHORT flags,USHORT result,ByteArray* options/*input NULL if no options*/);//used for outgoing packets
    L2CAP_ConfigureResponseCommandPacket(ByteArray *wholePacket); //used for incoming packets.... //must verify that the length is not smaller than the minimum parameter (throw up if not) length because dereferencing unallocated areas might cause fatal problems
	
	L2CAP_ConfigureResponseCommandParametersStruct theParameters;
	

};





#endif
