#pragma once

#include "HCIClient.h"
#include "L2CAPClientCaller.h"
#include "L2CAPClient.h"
#include "L2CAPConnection.h"

#define L2CAP_Level_Start 0
//send ConReq
#define L2CAP_Level_WaitingForConResp 1
//send ConfReq
#define L2CAP_Level_Configuring 2
#define L2CAP_Level_Configured 3

#define L2CAP_Level_Disconnecting 4
#define L2CAP_Level_Disconnected 5


class L2CAPServer : HCIClientCaller
	{
	public:
		
		
		static L2CAPServer* getInstance(CListBox *lb);
		bool ConnectAndConfig(L2CAPClient* caller,BTDevice dev,BYTE PSM);
		bool Disconnect(L2CAPClient* caller,bool disconnectHCI);		
		bool SendL2CAPPacket(L2CAPClient* caller,L2CAP_Packet* pkt);
		bool SendL2CAPPayload(L2CAPClient* caller,BYTE* payLoad, USHORT length);

		//from hciclientcaller
		void OnInput(USHORT handle, BYTE* payLoad, USHORT length);
		void OnDisconnect(USHORT handle);
		
		TidyVector SourceHCIClients;
		CPtrArray L2CAPClients;
		
		~L2CAPServer(void);
	
	protected:
		static L2CAPServer* curInstance;
		L2CAPServer(CListBox* lb);
		CListBox* logLB;				
		USHORT ourMTU;
		USHORT prevCID;
		

		

	};
