#ifndef _L2CAPSTRUCTS_H_
#define _L2CAPSTRUCTS_H_

#define BYTE unsigned char
#define USHORT unsigned short
#define UWORD unsigned int


typedef struct 
{
	USHORT length;
	USHORT CID;
	BYTE data[1];

} *L2CAP_PacketStruct;//, *L2CAPPacketStructPtr;




typedef struct
{
	BYTE code;
	BYTE identifier;
	USHORT length;
	BYTE data[1];

} *L2CAP_CommandStruct;//, *L2CAPCommandStructPtr;




typedef struct
{
	USHORT DestCID;
	USHORT SrcCID;

} *L2CAP_DisconnectRequestCommandParametersStruct;

typedef struct
{
	USHORT DestCID;
	USHORT SrcCID;

} *L2CAP_DisconnectResponseCommandParametersStruct;





typedef struct
{
	USHORT reason;
	USHORT data; // if no data, set it to 0
} *L2CAP_CommandRejectCommandParametersStruct;


typedef struct 
{
	USHORT PSM;
	USHORT srcCID;

} *L2CAP_ConnectionRequestCommandParametersStruct;//, *L2CAPConnectionRequestStructPtr;



typedef struct 
{
	USHORT destCID;
	USHORT srcCID;
	USHORT result;
	USHORT status;

} *L2CAP_ConnectionResponseCommandParametersStruct;//, *L2CAPConnectionResponseStructPtr;








typedef struct 
{
	USHORT destCID;
	USHORT Cflag	:1;
	USHORT reserved :15;
	//BYTE	options[4]; //allocate and just put it after the "result" if you want to have options
	
}	*L2CAP_ConfigureRequestCommandParametersStruct;
typedef struct 
{
	USHORT srcCID;

	USHORT Cflag	:1;
	USHORT reserved :15;

	USHORT result;
	//BYTE	options[4]; //allocate and just put it after the "result" if you want to have options
	
}	*L2CAP_ConfigureResponseCommandParametersStruct;



typedef struct
{
	BYTE OptionType;
	BYTE length;
	USHORT parameter;
	
} *L2CAP_ConfigureOption;

#endif
