#ifndef OBEX_H
#define OBEX_H
#include "OBEXStructs.h"
#include "Conversions.h"

#define vCardNameStrLen 12	//exclude null as normal strlen
#define obexProfileStrLen 21 //exclude null as normal strlen



class OBEXPacket
{

	public:
		OBEXPacket(BYTE code, BYTE* payLoad, USHORT payLoadLength);
		OBEXPacket(BYTE* array, USHORT Length);
		~OBEXPacket();

	USHORT packetLength;
	OBEXPacketStruct* wholePacket;	
	private:
	BYTE allocated;
};

class OBEXConnectPacket : public OBEXPacket
{
	public:
		OBEXConnectPacket(BYTE code, USHORT MaxOBEXPacketLength);
		OBEXConnectPacket(BYTE* array, USHORT length);
		
	
	OBEXConnectParamsStruct* params;
	USHORT paramsLength;

};

class OBEXPutCommand /*this is NOT inherited from OBEXPacket. This generates OBEX put packets in sequence using BYTE* CgetNextPacket(USHORT* packetLength) until the last packet that completes the seding of the whole file*/
{
	public:	
		OBEXPutCommand(USHORT MaxOBEXPacketLength, CStdioFile* file);		
		OBEXPutCommand(BYTE* array, USHORT length);//reverse, incoming
		
		OBEXPacket* CgetNextPacket(); //use this for normal/no-profile objects/files
		OBEXPacket* CgetNextVcardPacket(); //use this for vCard objects
		
		USHORT nPacketsToSend;

	private:
		CStdioFile* file;
		bool IsVcard;
		bool IsVcal;

		DWORD chunkBuffPos;
		DWORD packetCount;
		DWORD firstHeadersLength;
		DWORD consequtiveHeadersLength;
		DWORD sumBytesToSendAllPackets;

		USHORT MaxOBEXPacketSize;

		//static const char* vCardName;//INCLUDING NULL!!!// = ("text/x-vCard");
		//static const char* obexProfile;//INCLUDING NULL!!!//("x-obex/object-profile");

		

};



#endif