#ifndef RFCOMM_H
#define RFCOMM_H

#include "fcsmaker.h"
#include "RFCOMMStructs.h"

class ByteEncoder
{
	public:

	static AddressStruct MakeAddressStruct(BYTE CR,BYTE D,BYTE Channel);

	static BYTE MakeControlByte(BYTE Control,BYTE PF);

	static USHORT MakeLengthBytes(USHORT length); // treat the returned USHORT as 2 bytes of array data

	static LengthStruct MakeSmallLengthStruct(BYTE length);

	static TypeStruct MakeTypeStruct(BYTE CR, BYTE type);

	static InitialCreditStruct MakeInitialCreditStruct(BYTE credits);
};

class RFCOMM_Frame
{
	
		
	public:
		RFCOMM_Frame(AddressStruct addr, BYTE cntrl, BYTE* payLoad,USHORT payLoadLength /*length is already set in LengthStruct l, append FCS */);
		RFCOMM_Frame(BYTE* array, USHORT length);
		RFCOMM_Frame(USHORT payLoadLength);
		~RFCOMM_Frame();

		AddressStructPtr address;
		BYTE* control;
		LengthStructPtr length;

		USHORT packetLength;
		BYTE* wholePacket;
		USHORT payLoadLength;
		BYTE* payLoad;
	protected:
		BYTE allocated;

	

};

// consider making SABM UA UIH DISC or not (or just use the control byte of there are no parameters in any frame)
 class NoCreditDataUIH_Frame : public RFCOMM_Frame // the UIH frame for sending OBEX data
{
	public:
		NoCreditDataUIH_Frame( AddressStruct addr, BYTE* payLoad, USHORT length); 

		NoCreditDataUIH_Frame(BYTE* array, USHORT length); // use this to decode an incoming DataUIH frame


};

class Signalling_Frame: public RFCOMM_Frame
{
	public:
		Signalling_Frame(BYTE CR, BYTE cntrl, BYTE* payLoad, USHORT payLoadLength);
		Signalling_Frame(BYTE* array,USHORT length);	
};

class UA_Frame : public RFCOMM_Frame
{
	public:
		UA_Frame(AddressStruct addr);
		UA_Frame(BYTE* array,USHORT length);	

};


class SABM_Frame : public RFCOMM_Frame
{
	public:
		SABM_Frame(AddressStruct addr);
		SABM_Frame(BYTE* array,USHORT length);	

};

class DISC_Frame : public RFCOMM_Frame
{
	public:
		DISC_Frame(AddressStruct addr);
		DISC_Frame(BYTE* array,USHORT length);	
};

class DM_Frame : public RFCOMM_Frame
{

	public:
		DM_Frame(AddressStruct addr);
		DM_Frame(BYTE* array,USHORT length);	
};


class SignallingUIH_Frame : public Signalling_Frame
{
	//UIH frames: C/R is always meant as a command (see 07.10 doc) so if initialtor -> responder: C/R = 1. If packet from responder to initiator C/R =0 (it's a command, see 07.10 doc for C/R value rules table)
	public:
		SignallingUIH_Frame(BYTE CR, BYTE* payLoad, USHORT length); // use this to make a UIH Frame with your payload which would be a PN or MSC Message ... etc, 
		SignallingUIH_Frame(BYTE* array, USHORT length); // use this to decode an incoming UIH frame

};

//Data UIH is defined after Credited RFCOMM frame's definition

class RFCOMM_MultiplexerFrame : public SignallingUIH_Frame
{
	public:
		RFCOMM_MultiplexerFrame(BYTE CR, TypeStruct Type,LengthStruct Length/*length is in Length*/);
		RFCOMM_MultiplexerFrame(BYTE* array, USHORT length);

		TypeStructPtr messageTypeStr;
		LengthStructPtr messageLengthStr;

		BYTE* theParams;
		USHORT paramsLength;	
		
	protected:
		RFCOMM_MultiplexerFrame(TypeStructPtr Type,LengthStructPtr Length);
};

class PN_Command_Frame : public RFCOMM_MultiplexerFrame
{
	public:
	PN_Command_Frame(BYTE OuterCR, BYTE InnerCR,  AddressStruct DLCI, USHORT maxFrameSz, InitialCreditStruct initialCredits);
	PN_Command_Frame(BYTE* array, USHORT length);
	PNCommandValuesStructPtr vals;

};


class MSC_Command_Frame : public RFCOMM_MultiplexerFrame
{
	public:
	
	MSC_Command_Frame(BYTE OuterCR, BYTE InnerCR, AddressStruct DLCI, BYTE FC, BYTE RTC, BYTE RTR);
	MSC_Command_Frame(BYTE* array, USHORT length);

};





class CreditedRFCOMM_Frame
{
	
		
	public:
		CreditedRFCOMM_Frame(AddressStruct addr, BYTE cntrl,BYTE crd, BYTE* payLoad,USHORT payLoadLength);
		CreditedRFCOMM_Frame(BYTE* array, USHORT length);
		~CreditedRFCOMM_Frame();
		AddressStructPtr address;
		BYTE* control;
		LengthStructPtr length;
		BYTE* credit;

		USHORT packetLength;
		BYTE* wholePacket;
		USHORT payLoadLength;
		BYTE* payLoad;

	protected:
		BYTE allocated;
	

};



class CreditedDataUIH_Frame : public CreditedRFCOMM_Frame // the credited UIH frame for sending OBEX data
{
	public:
		CreditedDataUIH_Frame( AddressStruct addr, BYTE credits, BYTE* payLoad, USHORT length); 

		CreditedDataUIH_Frame(BYTE* array, USHORT length); // use this to decode an incoming DataUIH frame


};


#endif