#ifndef RFCOMMSTRUCTS_H
#define RFCOMMSTRUCTS_H

#ifndef BYTE 
#define BYTE unsigned char
#endif
#ifndef USHORT 
#define USHORT unsigned short
#endif

#define SetPF_Factor 0x10 //2 pow 4 -> 5th bit
//All these Control values have p/f =0 ; not set, add the SetPF_Factor to set p/f

#define RFCOMM_Header_Length 3

#define RFCOMM_AddressOffset 0
#define RFCOMM_ControlOffset 1
#define RFCOMM_LengthOffset  2

#define Control_SABM	0x2F
#define Control_UA		0x63
#define Control_DM		0x0F
#define Control_DISC	0x43
#define Control_UIH		0xEF

#define MultiplexerMessageHeaderLength 2

#define Type_PN		  0x20
#define Type_MSC	  0x38
#define Type_RPN	  0x24
#define Type_Test	  0x08
#define Type_FCon	  0x28
#define Type_FCoff	  0x18
#define Type_NSC	  0x04

#define MaxIn7Bits 127

#define RFCOMM_SignallingChannel 0
//const BYTE SignallingAddressWithCR(0x03);
//const BYTE SignallingAddressWithoutCR(0x01);
#define MultiplexerTypeOffset 0
#define MultiplexerLengthOffset 1
#define MultiplexerMessageParamsOffset 2

#define PNCommandValuesLength 8
#define MSCCommandValuesLength 2 //Address(DLCI) and 1 MSC byte

typedef struct 
{
	BYTE EA :1;
	BYTE CR :1;
	BYTE D:1;
	BYTE ServerChannel:5;

} AddressStruct,*AddressStructPtr;

typedef struct 
{
	BYTE EA :1;
	BYTE length:7; // can expand if ea=0, until ea=1	

} LengthStruct,*LengthStructPtr;

typedef struct 
{
	BYTE EA :1;
	BYTE CR:1;
	BYTE type:6;

} TypeStruct,*TypeStructPtr;


typedef struct
{
	AddressStruct Address;
	BYTE Control;
	LengthStruct Length; //this might expand (if EA=0) to the next byte
	BYTE PayloadAndFCS[1];	

} RFCOMM_FrameStruct,*RFCOMM_FrameStructPtr;


typedef struct
{
	AddressStruct Address;
	BYTE Control;
	LengthStruct Length; //this might expand (if EA=0) to the next byte
	BYTE Credit;
	BYTE PayloadAndFCS[1];	

} CreditedRFCOMM_FrameStruct, *CreditedRFCOMM_FrameStructPtr;


typedef struct
{
	
	BYTE D:1;
	BYTE ServerChannel:5;
	BYTE padding1:2;//this should be zeros 
	

	BYTE FrameType: 4; 
	BYTE CL:4; // BT spec: this must be set to 0 

	BYTE Priority:6;
	BYTE padding2:2;

	BYTE Timer; //BT spec: this must be 0

	USHORT MaxFrameSize;

	BYTE NA; // Max retransmissions

	BYTE InitialCredit:3;
	BYTE padding3:5;

}PNCommandValuesStruct, *PNCommandValuesStructPtr; // Encapsulated in UIH


typedef struct
{
	TypeStruct Type;
	LengthStruct Length;
	BYTE values[1]; //parameters

} RFCOMM_MultiplexorFrameStruct, *RFCOMM_MultiplexorFrameStructPtr;

typedef struct
{
	AddressStruct DLCI;
	BYTE EA:1;
	BYTE FC:1;
	BYTE RTC:1;
	BYTE RTR:1;
	BYTE padded:2;
	BYTE IC:1;
	BYTE DV:1;

} MSCParamsStruct, *MSCParamsStructPtr;

typedef struct
{
	BYTE K:3;
	BYTE padding:5;

} InitialCreditStruct, InitialCreditStructPtr;



#endif