#ifndef SDP_H
#define SDP_H

#include "L2CAPConnection.h"
#include "SDPStructs.h"
#include "Conversions.h"
#include "DataElement.h"

// U -> unsigned (when used infront of Int only! Don't confuse with UUID!)
// S -> signed

#define SDP_PDUHeaderLength    5

//DataElementTypeDescriptors


//DataElementSizeDescriptors  : use switch case functions

#define UUID_OBEXObjectPush 0x1105
#define UUID_OBEX			0x0008//protocol
#define UUID_RFCOMM			0x0003
#define UUID_L2CAP			0x0100

//PDU IDs

#define SDP_ErrorResPonsePDUID  0x01
#define SDP_ServiceSearchRequestPDUID   0x02
#define SDP_ServiceSearchResponsePDUID  0x03
#define SDP_ServiceAttributeRequestPDUID    0x04  
#define SDP_ServiceAttributeResponsePDUID   0x05
#define SDP_ServiceSearchAttributeRequestPDUID  0x06
#define SDP_ServiceSearchAttributeResponsePDUID 0x07

//Error Codes for ErrorResponsePDU

#define SDP_ErrorResponseCode_InvalidOrUnsopportedSDPVersion    0x0001
#define SDP_ErrorResponseCode_InvalidServiceRecordHandle    0x0002
#define SDP_ErrorResponseCode_InvalidRequestSyntax  0x0003 
#define SDP_ErrorResponseCode_InvalidPDUSize    0x0004 
#define SDP_ErrorResponseCode_InvalidContinuationState  0x0005
#define SDP_ErrorResponseCode_InsufficientResourcesToSatisfyRequest 0x0006


//All functions should DELETE all intermediate classes that come as parameters: BEUS*, BEUW*, DataElement* 
// BYTE* should NOT be deleted (delete[]) to avoid deleting fields that were allocated for other classes.


class SDP_PDU
    {
        public:

            SDP_PDU(BYTE pduID,BEUS* transactionID,BEUS* parameterLength, BYTE ContinuationState);
            SDP_PDU(BYTE* bp, USHORT length);
            BYTE getPDUID();
            BEUS* getTransactionIDBEUS();
            BEUS* getParameterLengthBEUS();
            BYTE       getContinuationState();

            
            
            BYTE* wholePDU;//points to the start of the header which is the start of the whole PDU, 
            USHORT wholePDULength;
            ~SDP_PDU(){if(allocatedOwnPDU) delete[] wholePDU;};  

            BYTE* theParameters;
            


            protected:
            BYTE allocatedOwnPDU; //flag for freeing memory if there was allocation: if the first constructor was used (the ByteArray constructor uses another object that it didn't allocate so it must not delete the ByteArray)
            
            
    };

class SDP_ErrorResponsePDU : public SDP_PDU
    {
    public:

        SDP_ErrorResponsePDU(BEUS* transactionID,BEUS* ErrorCode, BYTE* ErrorInfo, USHORT length);
        SDP_ErrorResponsePDU(BYTE* bp, USHORT length);
        BEUS*  getErrorCodeBEUS();
        BYTE* getErrorInfo(USHORT *retLength);

  //  private:
        
    
    
    };

class SDP_ServiceSearchRequestPDU :public SDP_PDU
    {
    public:

        SDP_ServiceSearchRequestPDU(BEUS* transactionID,DataElement* ServiceSeachPattern/*this is a DataElementSequence*/,BEUS* MaximumServiceRecordCount,BYTE ContinuationState);
        SDP_ServiceSearchRequestPDU(BYTE* bp, USHORT length);
        BYTE*      getSearchUUID(BYTE* nativeRetType);
        BEUS*      getMaximumServiceRecordCountBEUS();
        
    
    //private:

        

    };

class SDP_ServiceSearchResponsePDU  :public SDP_PDU
    {
    public:

        SDP_ServiceSearchResponsePDU(BEUS* transactionID,BEUS* TotalServiceRecordCount, BEUS* CurrentServiceRecordCount, BYTE* ServiceRecordHandleList,USHORT length, BYTE ContinuationState);
        SDP_ServiceSearchResponsePDU(BYTE* bp, USHORT length);
        BEUS*  getTotalServiceRecordCountBEUS();
        BEUS*  getCurrentServiceRecordCountBEUS();
        BYTE* getServiceRecordHandleList(USHORT* retLength); //List of 32 bit handles (ie., coimg one after another)
        
        
   // private:
        
        

    };

class SDP_ServiceAttributeRequestPDU :public SDP_PDU  //implement later, not used in our scope
    {
    public:
        SDP_ServiceAttributeRequestPDU(BEUS* transactionID, BEUW* ServiceRecordHandle, BEUS* MaximumAttributeByteCount,DataElement* AttributeIDList, BYTE Continuation);
        SDP_ServiceAttributeRequestPDU(BYTE* bp, USHORT length);
        BEUW* getServiceRecordHandle();
        BEUS* getMaximumAttributeByteCount();
        DataElement* getAttributeIDList();
        

  //  private:
        

    };

class SDP_ServiceAttributeResponsePDU   :public SDP_PDU //implement later, not used in our scope
    {
    public:
        SDP_ServiceAttributeResponsePDU(BEUS* transactionID,BEUS* AttributeListByteCount, DataElement* AttributeList, BYTE Continuation);
        SDP_ServiceAttributeResponsePDU(BYTE* bp, USHORT length);
        BEUS* getAttributeListByteCount();
        DataElement* getAttributeList();
        
   // private:
        
    };


#endif