#ifndef _SDPSTRUCTS_H
#define _SDPSTRUCTS_H

#ifndef BYTE
#define BYTE unsigned char
#endif

#ifndef USHORT
#define USHORT unsigned short
#endif

//All structs should be private or protected because we need to convert fields that are larger than 1 byte to Big-Endian format

typedef struct 
{
    //little endian used in windows so start from little to big
    BYTE sizeIndex  :3;//byte 0 //bit 0 to 2
    BYTE type :5; //byte 0 // bit 3 to 7
    // the coming bytes are to be dertermined by both of these at run time
} *SDP_DataElementHeaderStruct;//, *L2CAPPacketStructPtr;

typedef struct 
{
   BYTE pduID;
   BYTE BEUStransactionID[2]; // using BYTE[2] instead of USHORT because USHORT in windows is little-endian but SDP uses b-g-endian
   BYTE BEUSparameterLength[2];    

} *SDP_PDUHeaderStruct;


typedef struct
{
    BYTE BEUSTotalServiceRecordCount[2];
    BYTE BEUSCurrentServiceRecordCount[2];
    BYTE ServiceRecordHandleList[1]; // byteArray, this is just the start byte... to ensure that they come sequentially
    //continuation state is the last byte of the packet...

} *SDP_ServiceSearchResponseStruct;


typedef struct
{
    BYTE ServiceRecordHandle[4];
    BYTE MaximumAttributeByteCount[2];
    BYTE AttributeIDList[1];
    
} *SDP_ServiceAttributeRequestStruct;

typedef struct
{
    BYTE AttributeListByteCount[2];
    BYTE AttributeList[1];

} *SDP_ServiceAttributeResponseStruct;



#endif
