#include "StdAfx.h"
#include "BTServerTester.h"
#include "BTServerTesterDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CBTServerTesterDlg dialog



CBTServerTesterDlg::CBTServerTesterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBTServerTesterDlg::IDD, pParent)
	, m_deviceNameStr(_T(""))
	{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBTServerTesterDlg::DoDataExchange(CDataExchange* pDX)
{
CDialog::DoDataExchange(pDX);
//DDX_Control(pDX, IDC_LIST1, m_logLB);
DDX_Control(pDX, IDC_LIST3, m_devicesLB);
DDX_Control(pDX, IDC_LIST2, m_log);
DDX_Text(pDX, IDC_EDIT1, m_deviceNameStr);
DDX_Control(pDX, IDC_EDIT1, m_setNameTF);
}

BEGIN_MESSAGE_MAP(CBTServerTesterDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_LBN_SELCHANGE(IDC_LIST3, OnLbnSelchangeList3)
	ON_BN_CLICKED(IDC_BUTTON4, OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON3, OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON2, OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON1, OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON5, OnBnClickedButton5)
	ON_EN_CHANGE(IDC_EDIT1, OnEnChangeEdit1)
	ON_BN_CLICKED(IDC_BUTTON6, OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON7, OnBnClickedButton7)
END_MESSAGE_MAP()


// CBTServerTesterDlg message handlers

BOOL CBTServerTesterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	try{
		//HCI_Server = new HCIServer(&(this->m_log));
		carder = new FileSender(this, &(this->m_log),&(this->m_devicesLB));
		char log[30];		

		m_log.AddString(log);
		//if(carder == NULL)		
		//	throw "NULL!!!";

	//if(!this->GetServer())
	//	throw ("Unable to get the HCI Server!");
	
	//this->m_DevicesLB.ResetContent();
	//this->DoInquiry();
	
	///////////////////////////////////////////// 
	
		}
	catch(se_translator::exception& ex)
		{
			MessageBox(ex.description());
		}
	catch (char* error)
		{	MessageBox(error);exit(0);
		}
	  
	this->l2clnt = new L2CAPClient(this,&m_log);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBTServerTesterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBTServerTesterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBTServerTesterDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CBTServerTesterDlg::OnLbnSelchangeList3()
	{
	// TODO: Add your control notification handler code here
	}

void CBTServerTesterDlg::OnBnClickedButton4()
	{
		carder->Disconnect();
	}

void CBTServerTesterDlg::OnBnClickedButton3()
	{
	CStdioFile	ofile;
	CString tmpS;
	if(!ofile.Open("IOLog.log",CFile::modeCreate|CFile::modeWrite))
		{MessageBox("Please rename/backup and delete current IOLog.log file");return;}

	
	for(int i=0;i<this->m_log.GetCount();i++)
		{
			m_log.GetText(i,tmpS);

			ofile.WriteString(tmpS);
			ofile.WriteString("\n");
		}
	ofile.Close();
	}

void CBTServerTesterDlg::OnBnClickedButton2()
	{
	if((PBTDevice)carder->InquiredDevices->GetSize()!=0 && this->m_devicesLB.GetCurSel() >= 0 )
			{	PBTDevice dev = ((PBTDevice)carder->InquiredDevices->GetAt(m_devicesLB.GetCurSel()));
			if(dev!=NULL)
				{
				CStdioFile* file = new CStdioFile();
				if(file->Open("card.vcf" ,CFile::modeRead|CFile::typeBinary|CFile::shareDenyNone))
					carder->sendFileToDevice(file,*dev);
				}
			}
	}

void CBTServerTesterDlg::OnBnClickedButton1()
	{
	carder->DoInquiry();
	}

void CBTServerTesterDlg::OnBnClickedButton5()
	{
		BYTE szLocalName[FBT_HCI_NAME_SIZE]={0};
		
		this->m_setNameTF.GetWindowText((char *)&szLocalName,240);  
	

		HCIServer::getInstance(&this->m_log)->SendChangeLocalName(szLocalName);
	}

void CBTServerTesterDlg::OnEnChangeEdit1()
	{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	}

void CBTServerTesterDlg::OnInquiryComplete()
	{
		this->m_log.AddString("Got FileSenderCaller::OnInquiryCompplete() called");
	
	}
void CBTServerTesterDlg::OnSendSessionComplete(CStdioFile* file, bool success)
	{
	try{
		file->Close();
		delete file;
		file = NULL;
		}
	catch(se_translator::exception& ex)
		{
			this->m_log.AddString("Exception:");
			this->m_log.AddString(ex.description());
		}
		this->m_log.AddString("Got OnSendSessionComplete(CStdioFile* file, bool success) called");
		if(success)
		   m_log.AddString("OBEX object sent successfully");
		else
			m_log.AddString("Failed to send OBEX object.");

	}
void CBTServerTesterDlg::OnGetNamesComplete()
	{
		this->m_log.AddString("Got FileSenderCaller::OnGetNamesComplete() called");	
	}
void CBTServerTesterDlg::OnBnClickedButton6()
	{
		this->m_log.AddString("Strating to get names...");
		for(int i=0;i<this->m_devicesLB.GetCount();i++)
			if(this->carder->GetNames(i))
				this->m_log.AddString("Succeeded in name retrieval");
			else
				this->m_log.AddString("Failed in name retrieval");
	}

void CBTServerTesterDlg::OnBnClickedButton7()
	{
	if((PBTDevice)carder->InquiredDevices->GetSize()!=0 && this->m_devicesLB.GetCurSel() >= 0 )
			{	
			
			PBTDevice dev = ((PBTDevice)carder->InquiredDevices->GetAt(m_devicesLB.GetCurSel()));
			this->l2clnt->connect(*dev,L2CAP_PSM_SDP);


			}
	
	}
