/*
 * Decompiled with CFR 0.152.
 */
package ParkedAid;

import ParkedAid.CamRelated;
import ParkedAid.LoadingCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreFullException;

public class ParkedAid
extends MIDlet
implements CommandListener {
    private Form ParkedAtForm;
    private ImageItem imageItem2;
    private StringItem stringItem1;
    private Form SnapLocationForm;
    private ImageItem imageItem1;
    private TextField textField1;
    private Alert theAlert;
    private TextBox textBox1;
    private Command parkNowCommand;
    private Command cancelCommand1;
    private Command changeNotesCommand;
    private Command refreshCommand;
    private Command helpCommand1;
    private Command aboutCommand;
    private Command exitCommand;
    private Command saveAndExitCommand;
    private Command backCommand1;
    private Command saveCommand;
    private Command okCommand;
    private Image image1;
    Canvas takePicCanvas;
    Canvas loading = new LoadingCanvas();
    ParkedAid curInstance;
    boolean recordFound;
    boolean camSupport = false;
    Object cam;
    public static final long YearMilli = 31536000000L;
    public static final long MonthMilli = 2592000000L;
    public static final long DayMilli = 86400000L;
    public static final long MinuteMilli = 60000L;
    public static final long HourMilli = 3600000L;
    public static final long SecondMilli = 1000L;

    private void initialize() {
    }

    public void startMIDlet() {
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable displayable) {
        Display display = this.getDisplay();
        if (alert == null) {
            display.setCurrent(displayable);
        } else {
            display.setCurrent(alert, displayable);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.ParkedAtForm) {
            if (command == this.aboutCommand) {
                this.showAbout();
            } else if (command == this.cancelCommand1) {
                this.DeleteParkData();
            } else if (command == this.changeNotesCommand) {
                this.PrepareChangeNotes();
            } else if (command == this.exitCommand) {
                this.exitMIDlet();
            } else if (command == this.helpCommand1) {
                this.showHelp("This program helps you remember where you parked your car and calculates the parking duration. Use the <Park Now> command each time you park your car. Further help is provided in each screen.", (Displayable)this.ParkedAtForm);
            } else if (command == this.parkNowCommand) {
                this.getDisplay().setCurrent((Displayable)this.loading);
                this.loading.repaint();
                this.loading.serviceRepaints();
                this.PrepareParkDataEntry((Displayable)this.getSnapLocationForm());
            } else if (command == this.refreshCommand) {
                this.getParkData(false);
                this.showSuccess("Re-calculated park duration.", (Displayable)this.getParkedAtForm());
            }
        } else if (displayable == this.SnapLocationForm) {
            if (command == this.backCommand1) {
                if (this.SnapLocationForm.get(0) == this.imageItem1) {
                    this.getDisplay().setCurrent((Displayable)this.loading);
                    this.loading.repaint();
                    this.loading.serviceRepaints();
                    this.imageItem1.setImage(null);
                    this.PrepareParkDataEntry((Displayable)this.getParkedAtForm());
                } else {
                    this.getDisplay().setCurrent((Displayable)this.getParkedAtForm());
                }
            } else if (command == this.helpCommand1) {
                this.showHelp("You can enter some parking deatials such as the floor and building you parked your car.", (Displayable)this.SnapLocationForm);
            } else if (command == this.saveAndExitCommand) {
                this.SaveLog(true);
            } else if (command == this.saveCommand) {
                this.SaveLog(false);
            }
        } else if (displayable == this.textBox1) {
            if (command == this.backCommand1) {
                this.showInfo("Data NOT changed", (Displayable)this.getParkedAtForm());
            } else if (command == this.helpCommand1) {
                this.showHelp("You can edit the location & notes of your current parking here. This does not change other parking details. Choose <OK> to save your changes. ", (Displayable)this.textBox1);
            } else if (command == this.okCommand) {
                this.ResetLocation();
            }
        }
    }

    public Form getParkedAtForm() {
        if (this.ParkedAtForm == null) {
            this.ParkedAtForm = new Form("ParkedAid", new Item[]{this.getImageItem2(), this.getStringItem1()});
            this.ParkedAtForm.addCommand(this.getParkNowCommand());
            this.ParkedAtForm.addCommand(this.getCancelCommand1());
            this.ParkedAtForm.addCommand(this.getChangeNotesCommand());
            this.ParkedAtForm.addCommand(this.getRefreshCommand());
            this.ParkedAtForm.addCommand(this.getHelpCommand1());
            this.ParkedAtForm.addCommand(this.getAboutCommand());
            this.ParkedAtForm.addCommand(this.getExitCommand());
            this.ParkedAtForm.setCommandListener((CommandListener)this);
        }
        return this.ParkedAtForm;
    }

    public ImageItem getImageItem2() {
        if (this.imageItem2 == null) {
            this.imageItem2 = new ImageItem("Park Photo", null, 515, null);
        }
        return this.imageItem2;
    }

    public Form getSnapLocationForm() {
        if (this.SnapLocationForm == null) {
            this.SnapLocationForm = new Form("Parking Details", new Item[]{this.getImageItem1(), this.getTextField1()});
            this.SnapLocationForm.addCommand(this.getSaveAndExitCommand());
            this.SnapLocationForm.addCommand(this.getSaveCommand());
            this.SnapLocationForm.addCommand(this.getBackCommand1());
            this.SnapLocationForm.addCommand(this.getHelpCommand1());
            this.SnapLocationForm.setCommandListener((CommandListener)this);
        }
        return this.SnapLocationForm;
    }

    public ImageItem getImageItem1() {
        if (this.imageItem1 == null) {
            this.imageItem1 = new ImageItem("Snapshot", this.getImage1(), 515, null);
        }
        return this.imageItem1;
    }

    public TextField getTextField1() {
        if (this.textField1 == null) {
            this.textField1 = new TextField("Location & Notes:", "", 32, 0);
        }
        return this.textField1;
    }

    public Alert getTheAlert() {
        if (this.theAlert == null) {
            this.theAlert = new Alert("alert", "<Enter Text>", null, AlertType.INFO);
            this.theAlert.setTimeout(-2);
        }
        return this.theAlert;
    }

    public TextBox getTextBox1() {
        if (this.textBox1 == null) {
            this.textBox1 = new TextBox("Location&Notes", null, 120, 0);
            this.textBox1.addCommand(this.getOkCommand());
            this.textBox1.addCommand(this.getBackCommand1());
            this.textBox1.addCommand(this.getHelpCommand1());
            this.textBox1.setCommandListener((CommandListener)this);
        }
        return this.textBox1;
    }

    public Command getParkNowCommand() {
        if (this.parkNowCommand == null) {
            this.parkNowCommand = new Command("Park Now", 4, 1);
        }
        return this.parkNowCommand;
    }

    public Command getCancelCommand1() {
        if (this.cancelCommand1 == null) {
            this.cancelCommand1 = new Command("Clear Data", 4, 2);
        }
        return this.cancelCommand1;
    }

    public Command getChangeNotesCommand() {
        if (this.changeNotesCommand == null) {
            this.changeNotesCommand = new Command("Change Notes", 4, 2);
        }
        return this.changeNotesCommand;
    }

    public Command getRefreshCommand() {
        if (this.refreshCommand == null) {
            this.refreshCommand = new Command("Refresh", 4, 3);
        }
        return this.refreshCommand;
    }

    public Command getHelpCommand1() {
        if (this.helpCommand1 == null) {
            this.helpCommand1 = new Command("Help", 5, 4);
        }
        return this.helpCommand1;
    }

    public Command getAboutCommand() {
        if (this.aboutCommand == null) {
            this.aboutCommand = new Command("About", 5, 5);
        }
        return this.aboutCommand;
    }

    public Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 6);
        }
        return this.exitCommand;
    }

    public Command getSaveAndExitCommand() {
        if (this.saveAndExitCommand == null) {
            this.saveAndExitCommand = new Command("Save & Exit", 4, 1);
        }
        return this.saveAndExitCommand;
    }

    public Command getSaveCommand() {
        if (this.saveCommand == null) {
            this.saveCommand = new Command("Save", 4, 2);
        }
        return this.saveCommand;
    }

    public Command getBackCommand1() {
        if (this.backCommand1 == null) {
            this.backCommand1 = new Command("Back", 2, 3);
        }
        return this.backCommand1;
    }

    public Command getOkCommand() {
        if (this.okCommand == null) {
            this.okCommand = new Command("OK", 4, 1);
        }
        return this.okCommand;
    }

    public Image getImage1() {
        if (this.image1 == null) {
            try {
                this.image1 = Image.createImage((String)"/ParkedAid/parkaid.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.image1;
    }

    public StringItem getStringItem1() {
        if (this.stringItem1 == null) {
            this.stringItem1 = new StringItem("Location & Time: ", "<No Data>");
        }
        return this.stringItem1;
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.getDisplay().setCurrent(null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public static boolean checkCameraSupport() {
        try {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            Class<?> clazz3 = null;
            clazz = Class.forName("javax.microedition.media.Manager");
            clazz2 = Class.forName("javax.microedition.media.Player");
            clazz3 = Class.forName("javax.microedition.media.control.VideoControl");
            if (clazz == null || clazz2 == null || clazz3 == null) {
                return false;
            }
            String string = System.getProperty("supports.video.capture");
            if (!string.equals("true")) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public ParkedAid() {
        System.gc();
        this.cam = null;
        this.camSupport = ParkedAid.checkCameraSupport();
        if (this.camSupport) {
            this.cam = new CamRelated(this, this.getImageItem1(), (Displayable)this.getSnapLocationForm());
        }
        this.getDisplay().setCurrent((Displayable)this.loading);
        this.loading.repaint();
        this.loading.serviceRepaints();
        this.curInstance = this;
        this.initialize();
        this.getParkData(true);
        this.getDisplay().setCurrent((Displayable)this.getParkedAtForm());
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void showError(String string, Displayable displayable) {
        this.getTheAlert().setTitle("Failed");
        this.getTheAlert().setString(string);
        this.getTheAlert().setType(AlertType.ERROR);
        this.getTheAlert().setTimeout(2000);
        if (displayable != null) {
            this.getDisplay().setCurrent(this.getTheAlert(), displayable);
        } else {
            this.getDisplay().setCurrent((Displayable)this.getTheAlert());
        }
    }

    public void showInfo(String string, Displayable displayable) {
        this.getTheAlert().setTitle("Info");
        this.getTheAlert().setString(string);
        this.getTheAlert().setType(AlertType.INFO);
        this.getTheAlert().setTimeout(2000);
        if (displayable != null) {
            this.getDisplay().setCurrent(this.getTheAlert(), displayable);
        } else {
            this.getDisplay().setCurrent((Displayable)this.getTheAlert());
        }
    }

    public void showInfoPause(String string, Displayable displayable) {
        this.getTheAlert().setTitle("Info");
        this.getTheAlert().setString(string);
        this.getTheAlert().setType(AlertType.INFO);
        this.getTheAlert().setTimeout(-2);
        if (displayable != null) {
            this.getDisplay().setCurrent(this.getTheAlert(), displayable);
        } else {
            this.getDisplay().setCurrent((Displayable)this.getTheAlert());
        }
    }

    public void showSuccess(String string, Displayable displayable) {
        this.getTheAlert().setTitle("Success");
        this.getTheAlert().setString(string);
        this.getTheAlert().setType(AlertType.INFO);
        this.getTheAlert().setTimeout(2000);
        if (displayable != null) {
            this.getDisplay().setCurrent(this.getTheAlert(), displayable);
        } else {
            this.getDisplay().setCurrent((Displayable)this.getTheAlert());
        }
    }

    public void showHelp(String string, Displayable displayable) {
        this.getTheAlert().setTitle("Help");
        this.getTheAlert().setString(string);
        this.getTheAlert().setType(AlertType.INFO);
        this.getTheAlert().setTimeout(-2);
        if (displayable != null) {
            this.getDisplay().setCurrent(this.getTheAlert(), displayable);
        } else {
            this.getDisplay().setCurrent((Displayable)this.getTheAlert());
        }
    }

    public void showAbout() {
        this.getTheAlert().setTitle("About");
        this.getTheAlert().setString("ParkedAid Version 1.4 by www.ClearEvo.com - this software is FREE! Please help the poor, the orphans, the needy and spend in charity! Do good and stay away from bad. May God Guide & Bless.");
        this.getTheAlert().setType(AlertType.INFO);
        this.getTheAlert().setTimeout(-2);
        this.getDisplay().setCurrent(this.getTheAlert(), (Displayable)this.getParkedAtForm());
    }

    public void SaveLog(boolean bl) {
        try {
            this.getDisplay().setCurrent((Displayable)this.loading);
            System.gc();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(System.currentTimeMillis());
            RecordStore recordStore = null;
            try {
                RecordStore.deleteRecordStore((String)"parktime");
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordStore = RecordStore.openRecordStore((String)"parktime", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            } else {
                recordStore.setRecord(1, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            }
            recordStore.closeRecordStore();
            recordStore = null;
            byteArrayOutputStream.reset();
            String string = null;
            string = this.getTextField1().getString();
            if (string == null || string.equals("")) {
                string = "Data was not entered.";
            }
            dataOutputStream.writeUTF(string);
            try {
                RecordStore.deleteRecordStore((String)"parkloc");
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordStore = RecordStore.openRecordStore((String)"parkloc", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            } else {
                recordStore.setRecord(1, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            }
            recordStore.closeRecordStore();
            recordStore = null;
            byteArrayOutputStream.reset();
            if (this.cam != null) {
                try {
                    RecordStore.deleteRecordStore((String)"parkpic");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                recordStore = RecordStore.openRecordStore((String)"parkpic", (boolean)true);
                dataOutputStream.write(((CamRelated)this.cam).pngBytes, 0, ((CamRelated)this.cam).pngBytes.length);
                ((CamRelated)this.cam).pngBytes = null;
                if (recordStore.getNumRecords() == 0) {
                    recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                } else {
                    recordStore.setRecord(1, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                }
                recordStore.closeRecordStore();
                recordStore = null;
            }
            recordStore = null;
            this.imageItem1.setImage(null);
            dataOutputStream.close();
            byteArrayOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            System.gc();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            System.gc();
            this.showError("Please free some storage. Save Failed.", (Displayable)this.getSnapLocationForm());
            return;
        }
        catch (Exception exception) {
            System.gc();
            this.showError("Save Failed.", (Displayable)this.getSnapLocationForm());
            return;
        }
        if (!bl) {
            this.getParkData(true);
            this.showSuccess("Data saved.", (Displayable)this.getParkedAtForm());
        } else {
            this.showDataSavedCanvasAndExit();
        }
    }

    public void showDataSavedCanvasAndExit() {
        this.showInfo("Data Saved.", (Displayable)this.loading);
        try {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        1.sleep(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ParkedAid.this.destroyApp(true);
                    ParkedAid.this.notifyDestroyed();
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            this.destroyApp(true);
            this.notifyDestroyed();
        }
    }

    public void DeleteParkData() {
        try {
            RecordStore.deleteRecordStore((String)"parktime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)"parkloc");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)"parkpic");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getParkData(true);
        this.showSuccess("Data cleared.", (Displayable)this.getParkedAtForm());
    }

    public void getParkData(boolean bl) {
        this.recordFound = false;
        this.getDisplay().setCurrent((Displayable)this.loading);
        try {
            System.gc();
            byte[] byArray = null;
            RecordStore recordStore = RecordStore.openRecordStore((String)"parkloc", (boolean)false);
            byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            String string = "Location: ";
            string = string + dataInputStream.readUTF();
            recordStore.closeRecordStore();
            recordStore = null;
            byteArrayInputStream.close();
            dataInputStream.close();
            byArray = null;
            byteArrayInputStream = null;
            dataInputStream = null;
            System.gc();
            recordStore = RecordStore.openRecordStore((String)"parktime", (boolean)false);
            byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
            string = string + "\r\n";
            string = string + this.getDuration(dataInputStream.readLong());
            recordStore.closeRecordStore();
            recordStore = null;
            byteArrayInputStream.close();
            dataInputStream.close();
            byArray = null;
            byteArrayInputStream = null;
            dataInputStream = null;
            System.gc();
            this.getStringItem1().setText(string);
            this.recordFound = true;
            if (bl) {
                block7: {
                    try {
                        recordStore = RecordStore.openRecordStore((String)"parkpic", (boolean)false);
                        byArray = recordStore.getRecord(1);
                        recordStore.closeRecordStore();
                        recordStore = null;
                        System.gc();
                        this.getImageItem2().setImage(Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
                        if (this.getParkedAtForm().get(0) != this.imageItem2) {
                            this.getParkedAtForm().insert(0, (Item)this.imageItem2);
                        }
                    }
                    catch (Exception exception) {
                        if (this.getParkedAtForm().get(0) != this.imageItem2) break block7;
                        this.getParkedAtForm().delete(0);
                    }
                }
                byArray = null;
            }
            System.gc();
        }
        catch (Exception exception) {
            this.getStringItem1().setText("<No Data>");
            if (this.getParkedAtForm().get(0) == this.imageItem2) {
                this.getParkedAtForm().delete(0);
            }
            System.gc();
        }
    }

    public String getDuration(long l) {
        long l2;
        String string = "";
        string = "Parking Duration is ";
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        date.setTime(l);
        calendar.setTime(date);
        long l8 = l2 = System.currentTimeMillis() - calendar.getTime().getTime();
        boolean bl = false;
        if (l2 > 86400000L) {
            bl = true;
        }
        if (l2 >= 31536000000L) {
            l3 = l2 / 31536000000L;
            string = string + l3 + " Year(s) ";
            l2 -= l3 * 31536000000L;
        }
        if (l2 >= 2592000000L) {
            l4 = l2 / 2592000000L;
            string = string + l4 + " Months(s) ";
            l2 -= l4 * 2592000000L;
        }
        if (l2 >= 86400000L) {
            l5 = l2 / 86400000L;
            string = string + l5 + " Day(s) ";
            l2 -= l5 * 86400000L;
        }
        if (l2 >= 3600000L) {
            l6 = l2 / 3600000L;
            string = string + l6 + " Hour(s) ";
            l2 -= l6 * 3600000L;
        }
        if (l2 >= 60000L) {
            l7 = l2 / 60000L;
            string = string + l7 + " Minute(s).";
        } else {
            string = string + l2 / 1000L + " Second(s).";
        }
        if (bl) {
            string = string + " (" + l8 / 3600000L + " Hour(s) and ";
            string = string + l2 / 60000L + " Minute(s).";
        }
        string = string + "\nParked on " + this.getFullDate(calendar);
        calendar = null;
        date = null;
        System.gc();
        return string;
    }

    public String getFullDate(Calendar calendar) {
        String string = "";
        switch (calendar.get(7)) {
            case 2: {
                string = "Monday";
                break;
            }
            case 3: {
                string = "Tuesday";
                break;
            }
            case 4: {
                string = "Wednesday";
                break;
            }
            case 5: {
                string = "Thursday";
                break;
            }
            case 6: {
                string = "Friday";
                break;
            }
            case 7: {
                string = "Saturday";
                break;
            }
            case 1: {
                string = "Sunday";
            }
        }
        string = string + " " + Integer.toString(calendar.get(5)) + " ";
        switch (calendar.get(2)) {
            case 0: {
                string = string + "January";
                break;
            }
            case 1: {
                string = string + "February";
                break;
            }
            case 2: {
                string = string + "March";
                break;
            }
            case 3: {
                string = string + "April";
                break;
            }
            case 4: {
                string = string + "May";
                break;
            }
            case 5: {
                string = string + "June";
                break;
            }
            case 6: {
                string = string + "July";
                break;
            }
            case 7: {
                string = string + "August";
                break;
            }
            case 8: {
                string = string + "September";
                break;
            }
            case 9: {
                string = string + "October";
                break;
            }
            case 10: {
                string = string + "November";
                break;
            }
            case 11: {
                string = string + "December";
            }
        }
        string = string + " ";
        if (calendar.get(1) > 0) {
            string = string + Integer.toString(calendar.get(1));
            string = string + " (" + calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(1) + ")";
        } else {
            string = string + Integer.toString(Math.abs(calendar.get(1) - 1));
            string = string + " B.C. ";
            string = string + " (" + calendar.get(5) + "/" + (calendar.get(2) + 1) + "/" + (calendar.get(1) - 1) + ")";
        }
        string = string + " at ";
        int n = calendar.get(11);
        if (n < 10) {
            string = string + "0";
        }
        string = string + n;
        string = string + ":";
        n = calendar.get(12);
        if (n < 10) {
            string = string + "0";
        }
        string = string + n + " Hrs. (";
        n = calendar.get(10);
        if (n < 10) {
            string = string + "0";
        }
        string = string + n;
        string = string + ":";
        n = calendar.get(12);
        if (n < 10) {
            string = string + "0";
        }
        string = string + n + (calendar.get(9) == 0 ? " AM" : " PM") + ")";
        return string;
    }

    public void ResetLocation() {
        try {
            this.getDisplay().setCurrent((Displayable)this.loading);
            System.gc();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            String string = null;
            string = this.getTextBox1().getString();
            if (string == null) {
                string = "Data was not entered.";
            }
            dataOutputStream.writeUTF(string);
            RecordStore recordStore = RecordStore.openRecordStore((String)"parkloc", (boolean)false);
            recordStore.setRecord(1, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            recordStore.closeRecordStore();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            recordStore = null;
            System.gc();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            System.gc();
            this.showError("Please free some storage. Save Failed.", (Displayable)this.getSnapLocationForm());
            return;
        }
        catch (Exception exception) {
            System.gc();
            this.showError("Save Failed. Try <Park Now> first.", (Displayable)this.getParkedAtForm());
            return;
        }
        this.getParkData(false);
        this.showSuccess("Data saved.", (Displayable)this.getParkedAtForm());
    }

    public void PrepareChangeNotes() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"parkloc", (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.getTextBox1().setString(dataInputStream.readUTF());
            dataInputStream.close();
            byteArrayInputStream.close();
            recordStore = null;
            dataInputStream = null;
            byteArrayInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getDisplay().setCurrent((Displayable)this.getTextBox1());
    }

    public void PrepareParkDataEntry(Displayable displayable) {
        if (!this.camSupport) {
            if (this.getSnapLocationForm().get(0) == this.getImageItem1()) {
                this.getSnapLocationForm().delete(0);
            }
            this.getDisplay().setCurrent((Displayable)this.getSnapLocationForm());
        } else {
            try {
                if (this.getSnapLocationForm().get(0) != this.getImageItem1()) {
                    this.getSnapLocationForm().insert(0, (Item)this.getImageItem1());
                }
                ((CamRelated)this.cam).prepareTakePhoto();
            }
            catch (Exception exception) {
                if (this.getSnapLocationForm().get(0) == this.getImageItem1()) {
                    this.getSnapLocationForm().delete(0);
                }
                this.showError("Failed to load the camera.", displayable);
            }
        }
    }
}

