/*
Copyright (c) 2007-2008 Kasidit Yusuf
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


package ParkedAid;
import javax.microedition.lcdui.*; 
import javax.microedition.midlet.*;


public class CamRelated {
    public Object p,vc;
    public Canvas takePicCanvas;
    public Font  f2;
    //static boolean jpgsupport;
    
    byte[] pngBytes;
    public MIDlet mutter;
    public ImageItem imgItemForSnapShot;
    public static CamRelated curInstance;
    public Displayable afterSnap;
    
    public CamRelated(MIDlet mutter, ImageItem imgItemForSnapShot, Displayable afterSnap) 
    {
               
        
        this.mutter = mutter;
        this.imgItemForSnapShot = imgItemForSnapShot;
        this.afterSnap = afterSnap;
        curInstance = this;
               
         
         f2 = Font.getFont(Font.FACE_PROPORTIONAL,Font.STYLE_BOLD,Font.SIZE_MEDIUM);
         takePicCanvas = new Canvas()
           {
               public boolean processing = false;
               public void paint(Graphics g)
               {
                   g.setFont(f2);
                   g.drawString("Press Joystick or 5",this.getWidth()/2,this.getHeight()-10,g.BASELINE|g.HCENTER);
               }
                public void keyPressed(int keyCode)
               {
                    if(processing || (!takePicCanvas.isShown()) )
                        return;
                    
                    if(keyCode == this.KEY_NUM5 || this.FIRE == getGameAction(keyCode) )
                    {
                        processing = true;
                       
                        Thread t =  new Thread(){
                            
                            public void run(){
                       try
                        {                  
                            pngBytes = getSnapShot();
                            CamRelated.curInstance.imgItemForSnapShot.setImage(Image.createImage(pngBytes, 0, pngBytes.length));
                            Display.getDisplay(CamRelated.curInstance.mutter).setCurrent(CamRelated.curInstance.afterSnap);
                        }
                       catch(Exception e)                        
                        {
                          //  showError("Failed to get the snapshot.",get_ParkedAtForm());
                        }
                            }
                        
                        };
                        
                        t.start();
                        
                    }
               }
           };
        
        
        
    }
    
     public void prepareTakePhoto() throws Exception
    {
        
                      
                      System.gc();
                      p= null;              
                      
                      
                    try 
                    {    
                    //some nokia s40 phones - try this first because capture://video would pass here but fail on taking pic
                    p = javax.microedition.media.Manager.createPlayer("capture://image");                          
                    }
                    catch(Exception e1)
                    {p = javax.microedition.media.Manager.createPlayer("capture://video");}

                      
                      ((javax.microedition.media.Player)p).realize();
                      ((javax.microedition.media.Player)p).prefetch();
                      
                      vc = ((javax.microedition.media.Player)p).getControl("VideoControl");
                      
                       if (vc != null) 
                       {                      
                        Display.getDisplay(mutter).setCurrent(takePicCanvas);
                        ((javax.microedition.media.control.VideoControl)vc).initDisplayMode(javax.microedition.media.control.VideoControl.USE_DIRECT_VIDEO, takePicCanvas);                        
                        ((javax.microedition.media.control.VideoControl)vc).setVisible(true);
                        ((javax.microedition.media.Player)p).start();  
                        
                        }        
                      
                     /* if(get_SnapLocationForm().get(0)!=imageItem1)
                        get_SnapLocationForm().insert(0,imageItem1);                */
                        
                
    }
    
    public byte[] getSnapShot() throws Exception
    {
        
        
           byte[] ret = null; 
           ((javax.microedition.media.Player)p).stop();
           
          /*//if(jpgsupport)
           //{ 
               try{
                    ret = ((javax.microedition.media.control.VideoControl)vc).getSnapshot("jpeg");                                                                   
               }
               catch(Exception e){ret = null;}
               //if(ret == null)
                 //   ret = ((javax.microedition.media.control.VideoControl)vc).getSnapshot(null);                                                    
          // }
           else*/
               ret = ((javax.microedition.media.control.VideoControl)vc).getSnapshot(null);                                                    
           ((javax.microedition.media.Player)p).deallocate();
           ((javax.microedition.media.Player)p).close();
            p=null;
            vc = null;
            System.gc();
            return ret;
        
        
    }
    public void cancelSnap()
    {
    
        try 
        {
           
           ((javax.microedition.media.Player)p).stop();           
           ((javax.microedition.media.Player)p).deallocate();
           ((javax.microedition.media.Player)p).close();
            p=null;
            vc = null;                 
        }
        catch (Exception me){ }
        System.gc();
    }
    
}
