/*
Copyright (c) 2007-2008 Kasidit Yusuf
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


package ParkedAid;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreFullException;

public class ParkedAid extends MIDlet implements CommandListener {

// HINT - Uncomment for accessing new MIDlet Started/Resumed logic.
//    private boolean midletPaused = false;

    //<editor-fold defaultstate="collapsed" desc=" Generated Fields ">//GEN-BEGIN:|fields|0|
    private Form ParkedAtForm;
    private ImageItem imageItem2;
    private StringItem stringItem1;
    private Form SnapLocationForm;
    private ImageItem imageItem1;
    private TextField textField1;
    private Alert theAlert;
    private TextBox textBox1;
    private Command parkNowCommand;
    private Command cancelCommand1;
    private Command changeNotesCommand;
    private Command refreshCommand;
    private Command helpCommand1;
    private Command aboutCommand;
    private Command exitCommand;
    private Command saveAndExitCommand;
    private Command backCommand1;
    private Command saveCommand;
    private Command okCommand;
    private Image image1;
    //</editor-fold>//GEN-END:|fields|0|


// HINT - Uncomment for accessing new MIDlet Started/Resumed logic.
// NOTE - Be aware of resolving conflicts of the constructor.
//    /**
//     * The ConvertedParkedAid constructor.
//     */
//    public ConvertedParkedAid() {
//    }

    //<editor-fold defaultstate="collapsed" desc=" Generated Methods ">//GEN-BEGIN:|methods|0|
    //</editor-fold>//GEN-END:|methods|0|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: initialize ">//GEN-BEGIN:|0-initialize|0|0-preInitialize
    /**
     * Initilizes the application.
     * It is called only once when the MIDlet is started. The method is called before the <code>startMIDlet</code> method.
     */
    private void initialize() {//GEN-END:|0-initialize|0|0-preInitialize
        // write pre-initialize user code here
//GEN-LINE:|0-initialize|1|0-postInitialize
        // write post-initialize user code here
    }//GEN-BEGIN:|0-initialize|2|
    //</editor-fold>//GEN-END:|0-initialize|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: startMIDlet ">//GEN-BEGIN:|3-startMIDlet|0|3-preAction
    /**
     * Performs an action assigned to the Mobile Device - MIDlet Started point.
     */
    public void startMIDlet() {//GEN-END:|3-startMIDlet|0|3-preAction
        // write pre-action user code here
//GEN-LINE:|3-startMIDlet|1|3-postAction
        // write post-action user code here
    }//GEN-BEGIN:|3-startMIDlet|2|
    //</editor-fold>//GEN-END:|3-startMIDlet|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: resumeMIDlet ">//GEN-BEGIN:|4-resumeMIDlet|0|4-preAction
    /**
     * Performs an action assigned to the Mobile Device - MIDlet Resumed point.
     */
    public void resumeMIDlet() {//GEN-END:|4-resumeMIDlet|0|4-preAction
        // write pre-action user code here
//GEN-LINE:|4-resumeMIDlet|1|4-postAction
        // write post-action user code here
    }//GEN-BEGIN:|4-resumeMIDlet|2|
    //</editor-fold>//GEN-END:|4-resumeMIDlet|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: switchDisplayable ">//GEN-BEGIN:|5-switchDisplayable|0|5-preSwitch
    /**
     * Switches a current displayable in a display. The <code>display</code> instance is taken from <code>getDisplay</code> method. This method is used by all actions in the design for switching displayable.
     * @param alert the Alert which is temporarily set to the display; if <code>null</code>, then <code>nextDisplayable</code> is set immediately
     * @param nextDisplayable the Displayable to be set
     */
    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {//GEN-END:|5-switchDisplayable|0|5-preSwitch
        // write pre-switch user code here
        Display display = getDisplay();//GEN-BEGIN:|5-switchDisplayable|1|5-postSwitch
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }//GEN-END:|5-switchDisplayable|1|5-postSwitch
        // write post-switch user code here
    }//GEN-BEGIN:|5-switchDisplayable|2|
    //</editor-fold>//GEN-END:|5-switchDisplayable|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: commandAction for Displayables ">//GEN-BEGIN:|7-commandAction|0|7-preCommandAction
    /**
     * Called by a system to indicated that a command has been invoked on a particular displayable.
     * @param command the Command that was invoked
     * @param displayable the Displayable where the command was invoked
     */
    public void commandAction(Command command, Displayable displayable) {//GEN-END:|7-commandAction|0|7-preCommandAction
    // Insert global pre-action code here
        if (displayable == ParkedAtForm) {//GEN-BEGIN:|7-commandAction|1|24-preAction
            if (command == aboutCommand) {//GEN-END:|7-commandAction|1|24-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|2|24-postAction
                showAbout();
            } else if (command == cancelCommand1) {//GEN-LINE:|7-commandAction|3|16-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|4|16-postAction
                // Insert post-action code here
                
                DeleteParkData();
            } else if (command == changeNotesCommand) {//GEN-LINE:|7-commandAction|5|18-preAction
                PrepareChangeNotes();
//GEN-LINE:|7-commandAction|6|18-postAction
                // Insert post-action code here
            } else if (command == exitCommand) {//GEN-LINE:|7-commandAction|7|26-preAction
                // Insert pre-action code here
                exitMIDlet();//GEN-LINE:|7-commandAction|8|26-postAction
                // Insert post-action code here
            } else if (command == helpCommand1) {//GEN-LINE:|7-commandAction|9|22-preAction
                showHelp("This program helps you remember where you parked your car and calculates the parking duration. Use the <Park Now> command each time you park your car. Further help is provided in each screen.",ParkedAtForm);
//GEN-LINE:|7-commandAction|10|22-postAction
                // Insert post-action code here
            } else if (command == parkNowCommand) {//GEN-LINE:|7-commandAction|11|14-preAction
               this.getDisplay().setCurrent(loading);
                    loading.repaint();
                    loading.serviceRepaints();                    
                PrepareParkDataEntry(getSnapLocationForm());
//GEN-LINE:|7-commandAction|12|14-postAction
                // Insert post-action code here
            } else if (command == refreshCommand) {//GEN-LINE:|7-commandAction|13|20-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|14|20-postAction
                
                getParkData(false);
                
                showSuccess("Re-calculated park duration.",getParkedAtForm());
                
            }//GEN-BEGIN:|7-commandAction|15|37-preAction
        } else if (displayable == SnapLocationForm) {
            if (command == backCommand1) {//GEN-END:|7-commandAction|15|37-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|16|37-postAction
                if(SnapLocationForm.get(0)==imageItem1) {
                   this.getDisplay().setCurrent(loading);
                    loading.repaint();
                    loading.serviceRepaints();
                    imageItem1.setImage(null);
                    PrepareParkDataEntry(getParkedAtForm());
                } else
                    this.getDisplay().setCurrent(getParkedAtForm());
            } else if (command == helpCommand1) {//GEN-LINE:|7-commandAction|17|39-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|18|39-postAction
                showHelp("You can enter some parking deatials such as the floor and building you parked your car.",SnapLocationForm);
            } else if (command == saveAndExitCommand) {//GEN-LINE:|7-commandAction|19|33-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|20|33-postAction
                SaveLog(true);
            } else if (command == saveCommand) {//GEN-LINE:|7-commandAction|21|35-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|22|35-postAction
                SaveLog(false);
            }//GEN-BEGIN:|7-commandAction|23|46-preAction
        } else if (displayable == textBox1) {
            if (command == backCommand1) {//GEN-END:|7-commandAction|23|46-preAction
                showInfo("Data NOT changed", getParkedAtForm());
//GEN-LINE:|7-commandAction|24|46-postAction
                // Insert post-action code here
            } else if (command == helpCommand1) {//GEN-LINE:|7-commandAction|25|47-preAction
                // Insert pre-action code here
//GEN-LINE:|7-commandAction|26|47-postAction
                showHelp("You can edit the location & notes of your current parking here. This does not change other parking details. Choose <OK> to save your changes. ",textBox1);
            } else if (command == okCommand) {//GEN-LINE:|7-commandAction|27|45-preAction
                ResetLocation();
//GEN-LINE:|7-commandAction|28|45-postAction
                // Insert post-action code here
            }//GEN-BEGIN:|7-commandAction|29|7-postCommandAction
        }//GEN-END:|7-commandAction|29|7-postCommandAction
    // Insert global post-action code here
    }//GEN-BEGIN:|7-commandAction|30|
    //</editor-fold>//GEN-END:|7-commandAction|30|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: ParkedAtForm ">//GEN-BEGIN:|13-getter|0|13-preInit
    /**
     * Returns an initiliazed instance of ParkedAtForm component.
     * @return the initialized component instance
     */
    public Form getParkedAtForm() {
        if (ParkedAtForm == null) {//GEN-END:|13-getter|0|13-preInit
            // Insert pre-init code here
            ParkedAtForm = new Form("ParkedAid", new Item[] { getImageItem2(), getStringItem1() });//GEN-BEGIN:|13-getter|1|13-postInit
            ParkedAtForm.addCommand(getParkNowCommand());
            ParkedAtForm.addCommand(getCancelCommand1());
            ParkedAtForm.addCommand(getChangeNotesCommand());
            ParkedAtForm.addCommand(getRefreshCommand());
            ParkedAtForm.addCommand(getHelpCommand1());
            ParkedAtForm.addCommand(getAboutCommand());
            ParkedAtForm.addCommand(getExitCommand());
            ParkedAtForm.setCommandListener(this);//GEN-END:|13-getter|1|13-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|13-getter|2|
        return ParkedAtForm;
    }
    //</editor-fold>//GEN-END:|13-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: imageItem2 ">//GEN-BEGIN:|29-getter|0|29-preInit
    /**
     * Returns an initiliazed instance of imageItem2 component.
     * @return the initialized component instance
     */
    public ImageItem getImageItem2() {
        if (imageItem2 == null) {//GEN-END:|29-getter|0|29-preInit
/*            // Insert pre-init code here
imageItem2 = new ImageItem ("Park Photo", getImage1 (), ImageItem.LAYOUT_DEFAULT, "<Missing Image>");//GEN-LINE:|29-getter|1|29-postInit
*/
 imageItem2 = new ImageItem("Park Photo", null, ImageItem.LAYOUT_NEWLINE_AFTER | ImageItem.LAYOUT_CENTER, null);            

// Insert post-init code here
        }//GEN-BEGIN:|29-getter|2|
        return imageItem2;
    }
    //</editor-fold>//GEN-END:|29-getter|2|



    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: SnapLocationForm ">//GEN-BEGIN:|32-getter|0|32-preInit
    /**
     * Returns an initiliazed instance of SnapLocationForm component.
     * @return the initialized component instance
     */
    public Form getSnapLocationForm() {
        if (SnapLocationForm == null) {//GEN-END:|32-getter|0|32-preInit
            // Insert pre-init code here
            SnapLocationForm = new Form("Parking Details", new Item[] { getImageItem1(), getTextField1() });//GEN-BEGIN:|32-getter|1|32-postInit
            SnapLocationForm.addCommand(getSaveAndExitCommand());
            SnapLocationForm.addCommand(getSaveCommand());
            SnapLocationForm.addCommand(getBackCommand1());
            SnapLocationForm.addCommand(getHelpCommand1());
            SnapLocationForm.setCommandListener(this);//GEN-END:|32-getter|1|32-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|32-getter|2|
        return SnapLocationForm;
    }
    //</editor-fold>//GEN-END:|32-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: imageItem1 ">//GEN-BEGIN:|40-getter|0|40-preInit
    /**
     * Returns an initiliazed instance of imageItem1 component.
     * @return the initialized component instance
     */
    public ImageItem getImageItem1() {
        if (imageItem1 == null) {//GEN-END:|40-getter|0|40-preInit
            // Insert pre-init code here
            /*
imageItem1 = new ImageItem ("Snapshot", getImage1 (), ImageItem.LAYOUT_DEFAULT, "<Missing Image>");//GEN-LINE:|40-getter|1|40-postInit
            */
            imageItem1 = new ImageItem("Snapshot", getImage1(), ImageItem.LAYOUT_NEWLINE_AFTER | ImageItem.LAYOUT_CENTER, null);
             // Insert post-init code here
        }//GEN-BEGIN:|40-getter|2|
        return imageItem1;
    }
    //</editor-fold>//GEN-END:|40-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: textField1 ">//GEN-BEGIN:|41-getter|0|41-preInit
    /**
     * Returns an initiliazed instance of textField1 component.
     * @return the initialized component instance
     */
    public TextField getTextField1() {
        if (textField1 == null) {//GEN-END:|41-getter|0|41-preInit
            // Insert pre-init code here            
            textField1 = new TextField("Location & Notes:", "", 32, TextField.ANY);//GEN-LINE:|41-getter|1|41-postInit
            // Insert post-init code here         
            
        }//GEN-BEGIN:|41-getter|2|
        return textField1;
    }
    //</editor-fold>//GEN-END:|41-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: theAlert ">//GEN-BEGIN:|42-getter|0|42-preInit
    /**
     * Returns an initiliazed instance of theAlert component.
     * @return the initialized component instance
     */
    public Alert getTheAlert() {
        if (theAlert == null) {//GEN-END:|42-getter|0|42-preInit
            // Insert pre-init code here
            theAlert = new Alert("alert", "<Enter Text>", null, AlertType.INFO);//GEN-BEGIN:|42-getter|1|42-postInit
            theAlert.setTimeout(Alert.FOREVER);//GEN-END:|42-getter|1|42-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|42-getter|2|
        return theAlert;
    }
    //</editor-fold>//GEN-END:|42-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: textBox1 ">//GEN-BEGIN:|44-getter|0|44-preInit
    /**
     * Returns an initiliazed instance of textBox1 component.
     * @return the initialized component instance
     */
    public TextBox getTextBox1() {
        if (textBox1 == null) {//GEN-END:|44-getter|0|44-preInit
            // Insert pre-init code here
            textBox1 = new TextBox("Location&Notes", null, 120, TextField.ANY);//GEN-BEGIN:|44-getter|1|44-postInit
            textBox1.addCommand(getOkCommand());
            textBox1.addCommand(getBackCommand1());
            textBox1.addCommand(getHelpCommand1());
            textBox1.setCommandListener(this);//GEN-END:|44-getter|1|44-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|44-getter|2|
        return textBox1;
    }
    //</editor-fold>//GEN-END:|44-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: parkNowCommand ">//GEN-BEGIN:|15-getter|0|15-preInit
    /**
     * Returns an initiliazed instance of parkNowCommand component.
     * @return the initialized component instance
     */
    public Command getParkNowCommand() {
        if (parkNowCommand == null) {//GEN-END:|15-getter|0|15-preInit
            // Insert pre-init code here
            parkNowCommand = new Command("Park Now", Command.OK, 1);//GEN-LINE:|15-getter|1|15-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|15-getter|2|
        return parkNowCommand;
    }
    //</editor-fold>//GEN-END:|15-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: cancelCommand1 ">//GEN-BEGIN:|17-getter|0|17-preInit
    /**
     * Returns an initiliazed instance of cancelCommand1 component.
     * @return the initialized component instance
     */
    public Command getCancelCommand1() {
        if (cancelCommand1 == null) {//GEN-END:|17-getter|0|17-preInit
            // Insert pre-init code here
            cancelCommand1 = new Command("Clear Data", Command.OK, 2);//GEN-LINE:|17-getter|1|17-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|17-getter|2|
        return cancelCommand1;
    }
    //</editor-fold>//GEN-END:|17-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: changeNotesCommand ">//GEN-BEGIN:|19-getter|0|19-preInit
    /**
     * Returns an initiliazed instance of changeNotesCommand component.
     * @return the initialized component instance
     */
    public Command getChangeNotesCommand() {
        if (changeNotesCommand == null) {//GEN-END:|19-getter|0|19-preInit
            // Insert pre-init code here
            changeNotesCommand = new Command("Change Notes", Command.OK, 2);//GEN-LINE:|19-getter|1|19-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|19-getter|2|
        return changeNotesCommand;
    }
    //</editor-fold>//GEN-END:|19-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: refreshCommand ">//GEN-BEGIN:|21-getter|0|21-preInit
    /**
     * Returns an initiliazed instance of refreshCommand component.
     * @return the initialized component instance
     */
    public Command getRefreshCommand() {
        if (refreshCommand == null) {//GEN-END:|21-getter|0|21-preInit
            // Insert pre-init code here
            refreshCommand = new Command("Refresh", Command.OK, 3);//GEN-LINE:|21-getter|1|21-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|21-getter|2|
        return refreshCommand;
    }
    //</editor-fold>//GEN-END:|21-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: helpCommand1 ">//GEN-BEGIN:|23-getter|0|23-preInit
    /**
     * Returns an initiliazed instance of helpCommand1 component.
     * @return the initialized component instance
     */
    public Command getHelpCommand1() {
        if (helpCommand1 == null) {//GEN-END:|23-getter|0|23-preInit
            // Insert pre-init code here
            helpCommand1 = new Command("Help", Command.HELP, 4);//GEN-LINE:|23-getter|1|23-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|23-getter|2|
        return helpCommand1;
    }
    //</editor-fold>//GEN-END:|23-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: aboutCommand ">//GEN-BEGIN:|25-getter|0|25-preInit
    /**
     * Returns an initiliazed instance of aboutCommand component.
     * @return the initialized component instance
     */
    public Command getAboutCommand() {
        if (aboutCommand == null) {//GEN-END:|25-getter|0|25-preInit
            // Insert pre-init code here
            aboutCommand = new Command("About", Command.HELP, 5);//GEN-LINE:|25-getter|1|25-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|25-getter|2|
        return aboutCommand;
    }
    //</editor-fold>//GEN-END:|25-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: exitCommand ">//GEN-BEGIN:|27-getter|0|27-preInit
    /**
     * Returns an initiliazed instance of exitCommand component.
     * @return the initialized component instance
     */
    public Command getExitCommand() {
        if (exitCommand == null) {//GEN-END:|27-getter|0|27-preInit
            // Insert pre-init code here
            exitCommand = new Command("Exit", Command.EXIT, 6);//GEN-LINE:|27-getter|1|27-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|27-getter|2|
        return exitCommand;
    }
    //</editor-fold>//GEN-END:|27-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: saveAndExitCommand ">//GEN-BEGIN:|34-getter|0|34-preInit
    /**
     * Returns an initiliazed instance of saveAndExitCommand component.
     * @return the initialized component instance
     */
    public Command getSaveAndExitCommand() {
        if (saveAndExitCommand == null) {//GEN-END:|34-getter|0|34-preInit
            // Insert pre-init code here
            saveAndExitCommand = new Command("Save & Exit", Command.OK, 1);//GEN-LINE:|34-getter|1|34-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|34-getter|2|
        return saveAndExitCommand;
    }
    //</editor-fold>//GEN-END:|34-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: saveCommand ">//GEN-BEGIN:|36-getter|0|36-preInit
    /**
     * Returns an initiliazed instance of saveCommand component.
     * @return the initialized component instance
     */
    public Command getSaveCommand() {
        if (saveCommand == null) {//GEN-END:|36-getter|0|36-preInit
            // Insert pre-init code here
            saveCommand = new Command("Save", Command.OK, 2);//GEN-LINE:|36-getter|1|36-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|36-getter|2|
        return saveCommand;
    }
    //</editor-fold>//GEN-END:|36-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: backCommand1 ">//GEN-BEGIN:|38-getter|0|38-preInit
    /**
     * Returns an initiliazed instance of backCommand1 component.
     * @return the initialized component instance
     */
    public Command getBackCommand1() {
        if (backCommand1 == null) {//GEN-END:|38-getter|0|38-preInit
            // Insert pre-init code here
            backCommand1 = new Command("Back", Command.BACK, 3);//GEN-LINE:|38-getter|1|38-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|38-getter|2|
        return backCommand1;
    }
    //</editor-fold>//GEN-END:|38-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: okCommand ">//GEN-BEGIN:|43-getter|0|43-preInit
    /**
     * Returns an initiliazed instance of okCommand component.
     * @return the initialized component instance
     */
    public Command getOkCommand() {
        if (okCommand == null) {//GEN-END:|43-getter|0|43-preInit
            // Insert pre-init code here
            okCommand = new Command("OK", Command.OK, 1);//GEN-LINE:|43-getter|1|43-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|43-getter|2|
        return okCommand;
    }
    //</editor-fold>//GEN-END:|43-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: image1 ">//GEN-BEGIN:|30-getter|0|30-preInit
    /**
     * Returns an initiliazed instance of image1 component.
     * @return the initialized component instance
     */
    public Image getImage1() {
        if (image1 == null) {//GEN-END:|30-getter|0|30-preInit
            // Insert pre-init code here
            try {//GEN-BEGIN:|30-getter|1|30-@java.io.IOException
                image1 = Image.createImage("/ParkedAid/parkaid.png");
            } catch (java.io.IOException e) {//GEN-END:|30-getter|1|30-@java.io.IOException
                e.printStackTrace();
            }//GEN-LINE:|30-getter|2|30-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|30-getter|3|
        return image1;
    }
    //</editor-fold>//GEN-END:|30-getter|3|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: stringItem1 ">//GEN-BEGIN:|31-getter|0|31-preInit
    /**
     * Returns an initiliazed instance of stringItem1 component.
     * @return the initialized component instance
     */
    public StringItem getStringItem1() {
        if (stringItem1 == null) {//GEN-END:|31-getter|0|31-preInit
            // Insert pre-init code here
            stringItem1 = new StringItem("Location & Time: ", "<No Data>");//GEN-LINE:|31-getter|1|31-postInit
            // Insert post-init code here
        }//GEN-BEGIN:|31-getter|2|
        return stringItem1;
    }
    //</editor-fold>//GEN-END:|31-getter|2|




























 

















    /**
     * This method should return an instance of the display.
     */

    /**
     * Returns a display instance.
     * @return the display instance.
     */
public Display getDisplay () {

        return Display.getDisplay (this);
        // return Display.getDisplay (this);
}


    /**
     * This method should exit the midlet.
     */

    /**
     * Exits MIDlet.
     */
public void exitMIDlet() {

        getDisplay ().setCurrent (null);
        destroyApp (true);
        notifyDestroyed ();
        // switchDisplayable (null, null);
        // destroyApp(true);
        // notifyDestroyed();
}


    
    /**
     * Creates a new instance of ConvertedParkedAid 
     */
    Canvas takePicCanvas,loading;
    
    ParkedAid curInstance;
    
    boolean recordFound;    
    boolean camSupport = false;

    Object cam;
    
        public static final long YearMilli = 31536000000L, MonthMilli =2592000000L, DayMilli = 86400000L, MinuteMilli = 60000L,HourMilli = 3600000L,SecondMilli = 1000L;
    public static boolean checkCameraSupport()
    {
        //jpgsupport = false;
        try{
    Class manager=null,player=null,videocontrol=null;        
            manager = Class.forName("javax.microedition.media.Manager");
            player = Class.forName("javax.microedition.media.Player");
            videocontrol = Class.forName("javax.microedition.media.control.VideoControl");                                                
            
           if(manager ==null || player == null || videocontrol == null)
               return false;
           String s = System.getProperty("supports.video.capture");
           if(!s.equals("true"))        
               return false;
           
                   
           }
        catch(Exception e)
            {
            return false;
            }
        return true;
    }

    public ParkedAid() {
        
        
         
           loading = new LoadingCanvas();
           
           System.gc();
          
            
          cam=null; 
          camSupport = checkCameraSupport();
           if(camSupport)
           { 
               cam = new CamRelated(this, getImageItem1(), getSnapLocationForm());
               //((CamRelated)cam).takePicCanvas.addCommand(getHelpCommand1());
               //((CamRelated)cam).takePicCanvas.addCommand(getBackCommand1());
               
               /*((CamRelated)cam).takePicCanvas.setCommandListener( 
                   
                   new CommandListener()
                    {
                        public void commandAction(javax.microedition.lcdui.Command command, javax.microedition.lcdui.Displayable displayable) 
                        {
                           if(command == helpCommand1)
                           {
                           showHelp("Press the joystick \"IN\" (known as jog-dial or FIRE) to get a snapshot.", ((CamRelated)cam).takePicCanvas);
                           
                           }
                           else
                           if(command == backCommand1)
                           {
                            ((CamRelated)cam).cancelSnap();
                            Display.getDisplay(curInstance).setCurrent(getParkedAtForm());
                           
                           }
                        }
                    }
                    );       */  
        
           }    
           
           
          this.getDisplay().setCurrent(loading);
          loading.repaint();
          loading.serviceRepaints();
          curInstance = this;
                  
        initialize();
        
        getParkData(true);            
        this.getDisplay().setCurrent(getParkedAtForm());
        
        
    }
    

     
    public void startApp() {
        
    }
    
    public void pauseApp() {
    }
    
    public void destroyApp(boolean unconditional) {
    }
    public void showError(String s, Displayable nextScreen)
    {
        
        getTheAlert().setTitle("Failed");
        getTheAlert().setString(s);      
        getTheAlert().setType(AlertType.ERROR);
        getTheAlert().setTimeout(2000);
        
        if(nextScreen!=null)
            this.getDisplay().setCurrent(getTheAlert(),nextScreen);
        else
            this.getDisplay().setCurrent(getTheAlert());
    }
    
    public void showInfo(String s, Displayable nextScreen)
    {
        getTheAlert().setTitle("Info");
        getTheAlert().setString(s);            
        getTheAlert().setType(AlertType.INFO);
        getTheAlert().setTimeout(2000);
        
        
        if(nextScreen!=null)
            this.getDisplay().setCurrent(getTheAlert(),nextScreen);
        else
            this.getDisplay().setCurrent(getTheAlert());
    }
    public void showInfoPause(String s, Displayable nextScreen)
    {
        getTheAlert().setTitle("Info");
        getTheAlert().setString(s);            
        getTheAlert().setType(AlertType.INFO);
        getTheAlert().setTimeout(Alert.FOREVER);
        
        
        if(nextScreen!=null)
            this.getDisplay().setCurrent(getTheAlert(),nextScreen);
        else
            this.getDisplay().setCurrent(getTheAlert());
    }
    public void showSuccess(String s, Displayable nextScreen)
    {
        getTheAlert().setTitle("Success");
        getTheAlert().setString(s);            
        getTheAlert().setType(AlertType.INFO);
        getTheAlert().setTimeout(2000);
        
        
        if(nextScreen!=null)
            this.getDisplay().setCurrent(getTheAlert(),nextScreen);
        else
            this.getDisplay().setCurrent(getTheAlert());
    }
    public void showHelp(String s, Displayable nextScreen)
    {
        getTheAlert().setTitle("Help");
        getTheAlert().setString(s);            
        getTheAlert().setType(AlertType.INFO);
        getTheAlert().setTimeout(Alert.FOREVER);
        
        
        if(nextScreen!=null)
            this.getDisplay().setCurrent(getTheAlert(),nextScreen);
        else
            this.getDisplay().setCurrent(getTheAlert());
    }
    public void showAbout()
    {
        getTheAlert().setTitle("About");
        getTheAlert().setString("ParkedAid Version 1.4 by www.ClearEvo.com - this software is FREE! Please help the poor, the orphans, the needy and spend in charity! Do good and stay away from bad. May God Guide & Bless.");            
        getTheAlert().setType(AlertType.INFO);
        getTheAlert().setTimeout(Alert.FOREVER);   
        this.getDisplay().setCurrent(getTheAlert(),getParkedAtForm());
        
    }
   
    
    public void SaveLog(boolean exitAfterSave) 
    {
        // long time/ UTF location&notes / int size/ byte[] pic
        try
        {
            this.getDisplay().setCurrent(loading);
            System.gc();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(baos);                    
            dataOut.writeLong(System.currentTimeMillis());                
            RecordStore rs = null;                               
            try{
                    rs.deleteRecordStore("parktime");
                    }catch(Exception e){}
            rs = RecordStore.openRecordStore("parktime",true);            
            if(rs.getNumRecords()==0)
                rs.addRecord(baos.toByteArray(),0,baos.size());
            else
                rs.setRecord(1, baos.toByteArray(),0,baos.size());             
            rs.closeRecordStore();
            rs=null;
            baos.reset();            
            
            
            String loc = null;
            loc= this.getTextField1().getString();
            if(loc == null || loc.equals(""))
                loc = "Data was not entered.";
            dataOut.writeUTF(loc);
            try{
                    rs.deleteRecordStore("parkloc");
                    }catch(Exception e){}
            rs = RecordStore.openRecordStore("parkloc",true);            
            if(rs.getNumRecords()==0)
                rs.addRecord(baos.toByteArray(),0,baos.size());
            else
                rs.setRecord(1, baos.toByteArray(),0,baos.size()); 
            rs.closeRecordStore();
            rs=null;
            baos.reset();
            
            if(cam != null)
            {
               
                    try{
                    rs.deleteRecordStore("parkpic");
                    }catch(Exception e){}
                    
                    rs = RecordStore.openRecordStore("parkpic", true);
                    dataOut.write(((CamRelated)cam).pngBytes,0, ((CamRelated)cam).pngBytes.length);                
                    ((CamRelated)cam).pngBytes = null;                   
                    if(rs.getNumRecords()==0)
                        rs.addRecord(baos.toByteArray(),0,baos.size());
                    else
                        rs.setRecord(1, baos.toByteArray(),0,baos.size()); 
                    rs.closeRecordStore();
                    rs=null;        
            } 
            rs=null;
            imageItem1.setImage(null);             
            dataOut.close();
            baos.close();
            dataOut = null;
            baos = null;
            System.gc();            
        }
        catch(RecordStoreFullException re)
        {
            System.gc();            
            showError("Please free some storage. Save Failed.",getSnapLocationForm());           
            return;
        }
        catch(Exception e)
        {
            System.gc();            
            showError("Save Failed.",getSnapLocationForm());           
            return;
        }
        if(!exitAfterSave)
            {
                getParkData(true);
                showSuccess("Data saved.",getParkedAtForm());
            }
            else
            {
                showDataSavedCanvasAndExit();
            }            
    }
    public void showDataSavedCanvasAndExit()
    {
        showInfo("Data Saved.", loading);        
        try{
        Thread t = new Thread(){
        
            public void run()
            {
            try{
            this.sleep(2000);        
            }catch(Exception e){}
            destroyApp(true);notifyDestroyed();
            }
            
        };
        
        t.start();
        }
        catch(Exception e)
        {destroyApp(true);notifyDestroyed();}
        
        
    }
    
    public void DeleteParkData()
    {
    
        try{
    
            RecordStore.deleteRecordStore("parktime");
        }catch(Exception e)
        {
        }
        
        try{
            RecordStore.deleteRecordStore("parkloc");
            }catch(Exception e)
        {
        }
        
        try{
            
            RecordStore.deleteRecordStore("parkpic");
            }catch(Exception e)
        {
        }
        
         
         getParkData(true);
         showSuccess("Data cleared.",getParkedAtForm());
    }
    
     public void getParkData(boolean picAlso)
    {
        recordFound = false;
        
        this.getDisplay().setCurrent(loading);
        
        try{
        
        System.gc();
        byte[] bte = null;
        int size;
        ByteArrayInputStream bais;
        DataInputStream dataIn;             
        // long time/ UTF location&notes / int size/ byte[] pic              
                 
            
            
            RecordStore rs = RecordStore.openRecordStore("parkloc",false);
            bte = rs.getRecord(1);            
            bais = new ByteArrayInputStream(bte);            
            dataIn = new DataInputStream(bais);  
            String dat;
            dat = "Location: ";
            dat += dataIn.readUTF();
            
            rs.closeRecordStore();
            rs=null;
            bais.close();
            dataIn.close();
            bte=null;
            bais = null;
            dataIn = null;
            System.gc();
            
            
            rs = RecordStore.openRecordStore("parktime",false);                        
            /*if(rs.getNumRecords()!=4)
                return;*/
            bte = rs.getRecord(1);            
            bais = new ByteArrayInputStream(bte);            
            dataIn = new DataInputStream(bais);
            dat += "\r\n";
            dat += getDuration(dataIn.readLong());   //duration and parked time            
            rs.closeRecordStore();
            rs=null;
            bais.close();
            dataIn.close();
            bte=null;
            bais = null;
            dataIn = null;
            System.gc();       
            
            
            getStringItem1().setText(dat);//location and notes            
            
            
            recordFound = true;
            
            if(picAlso)
            {
            try
            {
                rs = RecordStore.openRecordStore("parkpic",false);
                bte = rs.getRecord(1);                               
                rs.closeRecordStore();            
                rs=null;
                System.gc();
                this.getImageItem2().setImage(Image.createImage(bte, 0,bte.length));                                          
                if(getParkedAtForm().get(0)!=imageItem2)
                      getParkedAtForm().insert(0,imageItem2);          
            }            
            catch(Exception e)
            {   
                if(getParkedAtForm().get(0)==imageItem2)
                    getParkedAtForm().delete(0);                
            }
            bte = null;            
            }            
            System.gc();
            
        }
        catch(Exception e)
        {
            getStringItem1().setText("<No Data>");
            
            if(getParkedAtForm().get(0)==imageItem2)
                getParkedAtForm().delete(0);
            
            System.gc();
        }
        
    }
    public String getDuration(long l)
    {
        Calendar c;
        Date dte;
        String ret = "";
        ret="Parking Duration is ";        
        long dur,oridur;        
        long y=0,months=0,d=0,hrs=0,minutes=0;
        
        
        c = Calendar.getInstance();
        dte = c.getTime();
        dte.setTime(l);
        c.setTime(dte);        
        
        
        dur = System.currentTimeMillis() - c.getTime().getTime();
        oridur = dur;
        boolean hoursum = false;
        if(dur>DayMilli)
            hoursum = true;
        //System.out.println(dur) ;
        if(dur>=YearMilli)
        { 
            y = dur/YearMilli;
            ret += y+" Year(s) " ;
            dur -= y*YearMilli; 
        }
        if(dur >= MonthMilli)
        {
            months = dur/MonthMilli;
            ret += months+" Months(s) ";
            dur -= months*MonthMilli; 
        }
        if(dur >= DayMilli)
        {
            d = dur/DayMilli;
            ret += d+" Day(s) ";
            dur -= d*DayMilli; 
        }
            
            if(dur >= HourMilli)
            {
                hrs = dur/HourMilli;
                ret += hrs+" Hour(s) ";           
                dur -= hrs*HourMilli;
            }
            
             if(dur >= MinuteMilli)
            {
                minutes = dur/MinuteMilli;
                //System.out.println("min: "+minutes);
                ret += minutes+" Minute(s).";            
                //ret += (dur%MinuteMilli)/SecondMilli+" Second(s).";            
            }
             else // < oneMinute
             {
                ret += (dur)/SecondMilli+" Second(s).";            
             }
        
        if(hoursum)      
        {
            ret+= " ("+oridur/HourMilli+" Hour(s) and ";
            ret+= dur/MinuteMilli+" Minute(s).";        
        }
        
        
                        
       ret +="\nParked on "+getFullDate(c);
       c=null; dte=null;
       System.gc();
        return ret;    
    }
    
    
    public String getFullDate(Calendar c)
   {
        String tmpS = "";
        switch(c.get(Calendar.DAY_OF_WEEK))
        {
             case Calendar.MONDAY:  tmpS = "Monday";break;   
            case Calendar.TUESDAY: tmpS = "Tuesday";break;   
            case Calendar.WEDNESDAY: tmpS = "Wednesday";break;   
            case Calendar.THURSDAY: tmpS = "Thursday";break;      
            case Calendar.FRIDAY: tmpS = "Friday";break;      
            case Calendar.SATURDAY:tmpS = "Saturday";break;      
            case Calendar.SUNDAY:tmpS = "Sunday";break;             
        }
        tmpS += " " + Integer.toString(c.get(Calendar.DAY_OF_MONTH)) +" ";
        
        switch(c.get(Calendar.MONTH))
        {
           case Calendar.JANUARY: tmpS += "January";break;
           case Calendar.FEBRUARY: tmpS += "February";break;   
            case Calendar.MARCH: tmpS += "March";break;   
            case Calendar.APRIL: tmpS += "April";break;      
            case Calendar.MAY: tmpS += "May";break;      
            case Calendar.JUNE:tmpS += "June";break;      
            case Calendar.JULY:tmpS += "July";break;                   
            case Calendar.AUGUST:tmpS += "August";break;                   
            case Calendar.SEPTEMBER:tmpS += "September";break;                   
            case Calendar.OCTOBER:tmpS += "October";break;                   
            case Calendar.NOVEMBER:tmpS += "November";break;                   
            case Calendar.DECEMBER:tmpS += "December";break;                 
       }
         tmpS +=" ";
        if(c.get(Calendar.YEAR) > 0)
        {
            tmpS += Integer.toString(c.get(Calendar.YEAR));
            tmpS+=" ("+c.get(c.DATE)+"/"+(c.get(c.MONTH)+1)+"/"+c.get(c.YEAR)+")";
        }
        else
        {
            tmpS += Integer.toString(java.lang.Math.abs(c.get(Calendar.YEAR)-1));
            tmpS += " B.C. ";
            tmpS+=" ("+c.get(c.DATE)+"/"+(c.get(c.MONTH)+1)+"/"+(c.get(c.YEAR)-1)+")";
        }
         tmpS += " at ";
         //c.get(c.HOUR_OF_DAY)+":"+c.get(c.MINUTE)+" Hrs. (";
         int n = c.get(c.HOUR_OF_DAY);
         if(n<10)
             tmpS+="0";
         tmpS+=n;
         tmpS+=":";
         n = c.get(c.MINUTE);
         if(n<10)
             tmpS+="0";
         tmpS+=n+" Hrs. (";
         n = c.get(c.HOUR);
         if(n<10)
             tmpS+="0";
         tmpS+=n;
         tmpS+=":";
         n = c.get(c.MINUTE);
         if(n<10)
             tmpS+="0";
         tmpS+=n+((c.get(c.AM_PM) == c.AM)?(" AM"):(" PM"))+")";
        return(tmpS);
        
   }
    
   public void ResetLocation()
   {
    try
        {            
            this.getDisplay().setCurrent(loading);
            System.gc();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(baos);                    
            String loc = null;
            loc= this.getTextBox1().getString();
            if(loc == null)
                loc = "Data was not entered.";
            dataOut.writeUTF(loc);      
            RecordStore rs = RecordStore.openRecordStore("parkloc",false);            
            rs.setRecord(1, baos.toByteArray(),0,baos.size());            
            rs.closeRecordStore();
            dataOut.close();
            baos.close();
            dataOut=null;
            baos=null;
            rs=null;            
            System.gc();
        }
        catch(RecordStoreFullException re)
        {
            System.gc();            
            showError("Please free some storage. Save Failed.",getSnapLocationForm());           
            return;
        }
        catch(Exception e)
        {
            
            System.gc();
            showError("Save Failed. Try <Park Now> first.",getParkedAtForm());           
            return;
        }
        getParkData(false);        
        showSuccess("Data saved.",getParkedAtForm());
        
   
   }
   public void PrepareChangeNotes()
   {
        try{
            RecordStore rs = RecordStore.openRecordStore("parkloc",false);
            byte[] bte = rs.getRecord(1);
            rs.closeRecordStore();
            ByteArrayInputStream bais = new ByteArrayInputStream(bte);
            DataInputStream dataIn = new DataInputStream(bais);                  
            getTextBox1().setString(dataIn.readUTF());
            dataIn.close();
            bais.close();            
            rs = null;
            dataIn = null;
            bais = null;
            System.gc();
        }
        catch(Exception e){}
        this.getDisplay().setCurrent(getTextBox1());
   }
   public void PrepareParkDataEntry(Displayable screenIfCamFailed)
   {
   
                 if(!camSupport)
                 {
                        if(getSnapLocationForm().get(0)==getImageItem1())
                            getSnapLocationForm().delete(0);               
                        this.getDisplay().setCurrent(getSnapLocationForm());                        
                 }
                 else
                 {
                    try
                     {
                        if(getSnapLocationForm().get(0)!=getImageItem1())
                                getSnapLocationForm().insert(0,getImageItem1());
                        ((CamRelated)cam).prepareTakePhoto();
                        
                     }
                     catch(Exception e)
                     {
                        if(getSnapLocationForm().get(0)==getImageItem1())
                            getSnapLocationForm().delete(0);               
                        showError("Failed to load the camera.",screenIfCamFailed);                        
                     }
                 }           
                 
           
   
   }


// HINT - Uncomment for accessing new MIDlet Started/Resumed logic.
// NOTE - Be aware of resolving conflicts of following methods.
//    /**
//     * Called when MIDlet is started.
//     * Checks whether the MIDlet have been already started and initialize/starts or resumes the MIDlet.
//     */
//    public void startApp() {
//        if (midletPaused) {
//            resumeMIDlet ();
//        } else {
//            initialize ();
//            startMIDlet ();
//        }
//        midletPaused = false;
//    }
//
//    /**
//     * Called when MIDlet is paused.
//     */
//    public void pauseApp() {
//        midletPaused = true;
//    }
//
//    /**
//     * Called to signal the MIDlet to terminate.
//     * @param unconditional if true, then the MIDlet has to be unconditionally terminated and all resources has to be released.
//     */
//    public void destroyApp(boolean unconditional) {
//    }

}
